<?php
/**
 * Share widget class
 *
 */
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

defined( 'ABSPATH' ) || die();

class back_pro_Social_Icons_Widget extends \Elementor\Widget_Base {
    /**
     * Get widget name.
     *
     * Retrieve back widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */

    public function get_name() {
        return 'back-social';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */

    public function get_title() {
        return esc_html__( 'Back Social Share', 'back' );
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-gallery-grid';
    }


    public function get_categories() {
        return [ 'backthemecore_category' ];
    }

    public function get_keywords() {
        return [ 'share', 'icon', 'social' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            '_section_logo',
            [
                'label' => esc_html__( 'Social Share', 'back' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'share_icon',
            [
                'label' => __( 'Icon', 'back' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => '',
                    'library' => 'reguler',
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'back'),
                'type' => Controls_Manager::URL,                
            ]
        ); 

        $repeater->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'back'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('', 'back'),
                'label_block' => true,
                'placeholder' => esc_html__( 'Description', 'back' ),
                'separator'   => 'before',
            ]
        );

        $repeater->add_group_control( 
            Group_Control_Background::get_type(), 
            [ 'name' => 'social_list_bg', 
            'types' => [ 'classic', 'gradient'], 
            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .back-icon-figure a' 
            ] 
        );

        $repeater->add_control(
            'social_list_color',
            [
                'label' => __( 'Color', 'back' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .back-icon-figure i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .back-icon-figure svg path' => 'fill: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'social_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );        

        $this->end_controls_section();

   
        $this->start_controls_section(
            '_section_style_grid',
            [
                'label' => esc_html__( 'Item', 'back' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-icon-share .back-icon-figure' => 'background: {{VALUE}};',
                ],               
            ]
        );

        $this->add_responsive_control(
            'icon_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .back-icon-share .back-icon-figure' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',           
                ],               
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__( 'Padding', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-icon-share .back-icon-figure' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'label' => esc_html__( 'Item Shadow', 'back' ),
                'selector' => '{{WRAPPER}} .back-icon-share .back-icon-figure',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_desc_style_grid',
            [
                'label' => esc_html__( 'Description Style', 'back' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'label' => esc_html__( 'Typography', 'back' ),
                'selector' => '{{WRAPPER}} .back-icon-figure .des__social em',
                'separator'   => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_m_typography',
                'label' => esc_html__( 'Followers Typography', 'back' ),
                'selector' => '{{WRAPPER}} .back-icon-figure .des__social',
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'desc_m_color',
            [
                'label' => esc_html__( 'Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-icon-figure .des__social' => 'color: {{VALUE}};',
                ],               
            ]
        ); 

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        $unique = rand(2012,35120);

        if ( empty($settings['social_list'] ) ) {
            return;
        }
        ?>

            <div class="back-unique-icon">
                <div class="back-icon-share">                      
                    <?php
                        foreach ( $settings['social_list'] as $index => $item ) :
                            $description  = !empty($item['description']) ? $item['description'] : '';
                            $target       = !empty($item['link']['is_external']) ? 'target=_blank' : '';  
                            $link         = !empty($item['link']['url']) ? $item['link']['url'] : '';
                            ?>
                            <div class="grid-item elementor-repeater-item-<?php echo $item['_id'];?>">
                                <div  class="back-icon-figure">                                    
                                        <a href="<?php echo esc_url($link);?>" <?php echo wp_kses_post($target);?>> 
                                            <?php if ( $item['share_icon'] ):
                                                Icons_Manager::render_icon( $item['share_icon'], [ 'aria-hidden' => 'true' ] );
                                            endif; ?>
                                        </a> <?php if(!empty($item['description'])):?> <span class="des__social"><?php echo wp_kses_post ($description);?> </span> <?php endif;?>                                    
                                </div>
                            </div>           
                        <?php endforeach; ?>                      
                </div>
                
            </div>

        <?php 

    }
}