<?php
/**
 * Elementor back cate Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

defined( 'ABSPATH' ) || die();

class back_Elementor_Pro_blog_category_Widget extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve back cate widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'backcategory-addon';
    }       
    
    /**
     * Get widget title.
     *
     * Retrieve back cate widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Back Category', 'back' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve back cate widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'glyph-icon flaticon-slider-1';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the back cate widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'backthemecore_category' ];
    }

    /**
     * Register back cate widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls() {       

      
        $post_categories = get_terms( 'category' );     

        $post_options = [];
        foreach ( $post_categories as $category ) {
            $post_options[ $category->slug ] = $category->name;
        }      


        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'back' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'category',
            [
                'label'   => esc_html__( 'Category', 'back' ),
                'type'    => Controls_Manager::SELECT2, 
                'label_block' => true,
                'options'     => $post_options,
                'default'     => [],
                'label_block' => true,
				'multiple' => true,	
                'separator' => 'before',        
            ]

        );

        $this->add_control(
            'blog_cat_layout',
            [
                'label' => esc_html__( 'Chosse Layout', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    'layout1' => esc_html__( 'Cate Layout 1', 'back' ),
                    'layout2' => esc_html__( 'Cate Layout 2', 'back' ),                   
                ],                
                'separator' => 'before',
            ]
        );
        


        $this->add_control(
            'blog_cat_show_hide',
            [
                'label' => esc_html__( 'Category Show/Hide', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => [
                    'yes' => esc_html__( 'Yes', 'back' ),
                    'no' => esc_html__( 'No', 'back' ),
                ],                
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'blog_cat_bg',
            [
                'label' => esc_html__( 'Cat Bg Show/Hide', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'yes',
                'options' => [
                    'yes' => esc_html__( 'Yes', 'back' ),
                    'no' => esc_html__( 'No', 'back' ),
                ],                
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_slider_style',
            [
                'label' => esc_html__( 'Category Style', 'back' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'blog_cat_color',
            [
                'label' => esc_html__( 'Category Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-category .single-category .category-part .category-title a' => 'color: {{VALUE}};',

                ],
                'condition' => [
                    'blog_cat_show_hide' => 'yes',
                ]                
            ]
        );

        $this->add_control(
            'blog_cat_bg_color',
            [
                'label' => esc_html__( 'Category Background Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-category .single-category .category-part .category-title' => 'background: {{VALUE}};',

                ], 
                'condition' => [
                    'blog_cat_show_hide' => 'yes',
                ]               
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__( 'Category Typography', 'back' ),
                'selector' => 
                    '{{WRAPPER}} .back-category .single-category .category-part .category-title a',
            ]
        );

         $this->add_control(
            'navigation_arrow_background',
            [
                'label' => esc_html__( 'Navigation Arrow Background', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-category .back-addon-slider .slick-next, .back-addon-slider .slick-prev' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .back-category .back-addon-slider .slick-next, .back-addon-slider .slick-next' => 'background: {{VALUE}};',

                ],                
            ]
        );

        $this->add_control(
            'navigation_arrow_border',
            [
                'label' => esc_html__( 'Navigation Arrow Border', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-category .back-addon-slider .slick-next, .back-addon-slider .slick-prev' => 'border: 1px solid {{VALUE}};',

                ],                
            ]
        );

        $this->add_control(
            'navigation_arrow_icon_color',
            [
                'label' => esc_html__( 'Navigation Arrow Icon Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-category .back-addon-slider .slick-next:after' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .back-category .back-addon-slider .slick-prev:before' => 'color: {{VALUE}};',

                ],                
            ]
        );
        $this->add_control(
            'circle_color',
            [
                'label' => esc_html__( 'Circle Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-addon-category .blog-item .single-category .category-part .category span' => 'color: {{VALUE}};',

                ],
                'separator' => 'before',                
            ]
        );
        $this->add_control(
            'circle_bg',
            [
                'label' => esc_html__( 'Circle Background', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-addon-category .blog-item .single-category .category-part .category span' => 'background: {{VALUE}};',

                ],
                'separator' => 'after',                
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__( 'Padding', 'prelements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-addon-category .blog-item .single-category .category-part' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-addon-category .blog-item .single-category .category-part' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',           
                ],
            ]
        );

        $this->start_controls_tabs( '_tabs_button' );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'back' ),
            ]
        ); 

        $this->add_control(
            'opacity',
            [
                'label' => esc_html__( 'Background Opacity', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .back-addon-category .blog-item .single-category .category-part .back_cat_overlay_bg' => 'opacity: {{SIZE}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'back' ),
            ]
        );
        $this->add_control(
            'opacity_hover',
            [
                'label' => esc_html__( 'Background Opacity', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .back-addon-category .blog-item .single-category .category-part:hover .back_cat_overlay_bg' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_tabs();
        $this->end_controls_section();  
    }

    /**
     * Render back cate widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();      
        $unique = rand(100,31120);        
        ?>
        
        <?php if(($settings['blog_cat_layout'] == 'layout1') ){ ?>
            <div class="back-post-category">
                <div class="back-addon-category">
                    <?php 

                        $categories = $settings['category'];       
                        foreach ( $categories as $category ) {
                        $category =  get_term_by('slug', $category, 'category');       
                        $theCatId = $category->term_id;                  
                        $cate_img     = get_term_meta($theCatId, 'category-images', true);
                        $cate_bg     = get_term_meta($theCatId, 'category_bg_color', true);
                        $count = $category->count;
                        $cate_bg = ($cate_bg) ? "Style=background:$cate_bg" : "" ;
                        if(!empty($settings['blog_word_show'])){
                            $limit = $settings['blog_word_show'];
                        }
                        else{
                            $limit = 20;
                        } ?>
                        <div class="blog-item">
                            <div class="single-category"> 
                                <?php if(($settings['blog_cat_bg'] == 'yes') ){ ?>
                                <div class="category-part" style="background-image: url(<?php if(($settings['blog_cat_bg'] == 'yes') ){ ?>
                                    <?php echo esc_url( $cate_img ); ?>
                                    <?php } ?>); background-position: center top;">
                                <?php } else { ?>
                                    <div class="category-part">
                                    <?php } ?>
                                    <?php if(!empty($cate_bg)){?>
                                        <div class="back_cat_overlay_bg"></div>
                                    <?php } ?>

                                     <?php if(($settings['blog_cat_show_hide'] == 'yes') ){ ?>
                                        <div class="category">
                                            <a href="<?php echo esc_url( get_category_link($category->term_id) ); ?>"><?php echo esc_html($category->name);?></a>
                                            <span><?php echo esc_html($category->count);?>
                                            <em class="back_cat_overlay_bg"></em>
                                            </span>
                                        </div>
                                     <?php } ?>
                                </div>                                
                            </div>                              
                        </div>
                    
                        <?php
                        };
                        wp_reset_query();  ?>              
                </div>
            </div>
        <?php } else { ?>
            <div class="back-post-category-image">
                <div class="back-addon-category-image">
                    <?php 

                        $categories = $settings['category'];       
                        foreach ( $categories as $category ) {
                        $category =  get_term_by('slug', $category, 'category');       
                        $theCatId = $category->term_id;                  
                        $cate_img     = get_term_meta($theCatId, 'category-images', true);
                        $count = $category->count;
                        if(!empty($settings['blog_word_show'])){
                            $limit = $settings['blog_word_show'];
                        }
                        else{
                            $limit = 20;
                        } ?>
                        <div class="blog-item">
                            <div class="single-category"> 
                                <?php if(($settings['blog_cat_bg'] == 'yes') ){ ?>
                                <div class="category-part" style="background-image: url(<?php if(($settings['blog_cat_bg'] == 'yes') ){ ?>
                                    <?php echo esc_url( $cate_img ); ?>
                                    <?php } ?>); background-position: center top;">
                                <?php } else { ?>
                                    <div class="category-part">
                                    <?php } ?>                                    
                                    <div class="back_cat_overlay_bg"></div>
                                     <?php if(($settings['blog_cat_show_hide'] == 'yes') ){ ?>
                                        <div class="category">
                                            <h4><?php echo esc_html($category->count);?>       
                                            </h4>
                                            <a href="<?php echo esc_url( get_category_link($category->term_id) ); ?>"><?php echo esc_html($category->name);?></a>
                                        </div>
                                     <?php } ?>
                                </div>                                
                            </div>                              
                        </div>
                    
                        <?php
                        };
                        wp_reset_query();  ?>              
                </div>
            </div>
        <?php } ?>
            
        <?php

    }
}