<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

$product_page_title = vibenews_get_option('product_page_title', true);

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>


<div class="theme-breadcrumb__Wrapper theme-breacrumb-area shop-details-breadcrumb">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
				<h1 class="theme-breacrumb-title">
					<?php if(!empty($product_page_title)) { echo esc_html($product_page_title); } else { echo esc_html_e('Porduct Details', 'vibenews');}?>
				</h1>
				<div class="breaccrumb-inner">
					<?php 
						if ( shortcode_exists( '[flexy_breadcrumb]' ) ) {
							echo do_shortcode( '[flexy_breadcrumb]');
						}
					?>
				</div>
            </div>
        </div>
    </div>
</div>

<div class="content-product-wrapper">
	<div class="container">
		<div class="row">
			<?php
				/**
				 * woocommerce_before_main_content hook.
				 *
				 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
				 * @hooked woocommerce_breadcrumb - 20
				 */
				do_action( 'woocommerce_before_main_content' );
			?>

				<?php while ( have_posts() ) : the_post(); ?>

					<?php wc_get_template_part( 'content', 'single-product' ); ?>

				<?php endwhile; // end of the loop. ?>

			<?php
				/**
				 * woocommerce_after_main_content hook.
				 *
				 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
				 */
				do_action( 'woocommerce_after_main_content' );
			?>

			<?php
				/**
				 * woocommerce_sidebar hook.
				 *
				 * @hooked woocommerce_get_sidebar - 10
				 */
				do_action( 'woocommerce_sidebar' );
			?>
		</div>
	</div>
</div>
<?php get_footer( 'shop' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
