<?php 

$blog_single_cat = vibenews_get_option('blog_single_cat');
$blog_single_author= vibenews_get_option('blog_single_author', false);
$blog_single_navigation = vibenews_get_option('blog_nav');
$blog_single_related = vibenews_get_option('blog_related');
$blog_single_taglist = vibenews_get_option('blog_tags');
$blog_single_views = vibenews_get_option('blog_views');

?>


<div id="main-content" class="bloglayout__One main-container blog-single post-layout-style2 single-one-bwrap theme-post-style-two"  role="main">
	<div class="container">
		<div class="row single-blog-content">

		<div class="<?php if(is_active_sidebar('sidebar-1')) { echo "col-lg-9"; } else { echo "col-lg-12";}?> col-md-12">
		<?php while (have_posts()):
		the_post(); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(["post-content", "post-single"]); ?>>

				<div class="blog_layout_one_Top">
					<div class="post-header-style1">
						<header class="entry-header clearfix single-blog-header">
						
						
						
					<?php if ( has_post_thumbnail() && !post_password_required() ) : ?>
						<div class="post-featured-image">
						<?php if(get_post_format()=='video'): ?>
							<?php get_template_part( 'template-parts/single/post', 'video' ); ?>  
							<?php else: ?>
							<img class="img-fluid" src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php the_title_attribute(); ?>">
							<?php endif; ?>
						</div>
						<?php endif; ?>
						
						
						<?php if($blog_single_cat == true) :?>
						<div class="blog-post-cat sblog_catt_design">
						<?php require VIBENEWS_THEME_DIR . '/template-parts/cat-color.php'; ?>
						</div>
						<?php endif; ?>	
						
						<h1 class="post-title single_blog_inner__Title">
						<?php the_title(); ?>
						</h1>
						
						<div class="blog-small-excerpt-box">
							<p><?php echo esc_html( wp_trim_words(get_the_excerpt(), 30 ,'') );?></p>
						</div>
						
						

						<div class="theme-blog-details-meta-wrap">
							<div class="slider-meta-left">

								<div class="slider-meta-left-author">
									<?php echo get_avatar( get_the_author_meta( 'ID' ), 60 ); ?>
								</div>
								
								<div class="slider-meta-left-content">

									<div class="post-author-name-item">
										<span><?php esc_html_e('By', 'vibenews'); ?></span><?php echo get_the_author_link(); ?>
									</div>

									<ul class="slider-bottom-meta-list">
										<li class="slider-meta-date"><span><?php esc_html_e('Published', 'vibenews'); ?></span><?php echo esc_html( get_the_date( 'F j, Y' ) ); ?></li>
									</ul>
								</div>
							</div>
							
							<div class="slider-meta-right">
								<div class="share-now-box">
									<?php echo do_shortcode("[addtoany]"); ?>
								</div>
							</div>
						</div>	

						
						</header>
					</div>  

				</div>
							
				<div class="theme-blog-details">
					<div class="post-body clearfix single-blog-header single-blog-inner blog-single-block blog-details-content">
						<!-- Article content -->
						<div class="entry-content clearfix">
							
							<?php
							if ( is_search() ) {
								the_excerpt();
							} else {
								the_content();
								vibenews_link_pages();
							}
							?>
							
						<?php if(has_tag() && $blog_single_taglist == true ) : ?>
						<div class="post-footer clearfix theme-tag-list-wrapp">
							<?php vibenews_single_post_tags(); ?>
						</div>
						 
						<?php endif; ?>	

						</div>
					</div>
				</div>
							
			</article>
					   
			<?php if($blog_single_author == true) :?>
				<?php vibenews_theme_author_box(); ?>
			<?php endif; ?>
		   
			<?php if($blog_single_navigation == true) :?>
				<?php vibenews_theme_post_navigation(); ?>
			<?php endif; ?>

			<?php endwhile; ?>
			
			</div>
					
			<?php if ( is_active_sidebar( 'sidebar-1' ) ) { ?>
			   <div class="col-lg-3 col-md-12">
				  <div id="sidebar" class="sidebar blog-sidebar">
					 <?php dynamic_sidebar( 'sidebar-1' ); ?>
				  </div> 
			   </div>
			<?php } ?>

		</div>
		
		<div class="row">
			<div class="col-lg-9">
				<?php if($blog_single_related == true) :?>
				<div class="theme_related_posts_Wrapper">
				<?php get_template_part('template-parts/single/related', 'posts'); ?>
				</div>
				<?php endif; ?>
			</div>
			<div class="col-lg-3">
			</div>
		</div>
		
		<div class="row">
			<div class="col-lg-9">
				<div class="theme_comments_box_Wrapper">
					<?php comments_template(); ?>
				</div>
			</div>
			<div class="col-lg-3">
			</div>
		</div>

	</div> 
	
</div>






