<?php
    if ( ! defined( 'ABSPATH' ) ) {
        exit; // Exit if accessed directly
    }
    
    $vibenews_logo = vibenews_get_option( 'theme_logo' );
    $vibenews_logo_id = isset($vibenews_logo['id']) && !empty($vibenews_logo['id']) ? $vibenews_logo['id'] : '';
    $vibenews_logo_url = isset( $vibenews_logo[ 'url' ] ) ? $vibenews_logo[ 'url' ] : '';
    $vibenews_logo_alt = get_post_meta($vibenews_logo_id,'_wp_attachment_image_alt',true);
    
    $vibenews_header_search = vibenews_get_option('search_bar_enable', true);
    $login_btn_enable = vibenews_get_option('login_btn_enable');
    $panel_bar_enable = vibenews_get_option('panel_bar_enable');
    
    $vibenews_header_social = vibenews_get_option('header_social_enable');
    $vibenews_social_icon = vibenews_get_option( 'social-icon' );

    $darkmode_enable = vibenews_get_option('darkmode_enable');
    
?>
	
<header id="theme-header-two" class="theme_header__main header-style-one custom-header-two">
    <div class="theme-logo-area">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-4 col-md-12">
                    <?php if($panel_bar_enable == true) :?>
                    <div class="header_panel_nav_wrap">
                        <div class="lv-header-bar-1">
                            <div class="panel-bar-box">
                                <span class="lv-header-bar-line lv-header-bar-line-1"></span>
                                <span class="lv-header-bar-line lv-header-bar-line-2"></span>
                                <span class="lv-header-bar-line lv-header-bar-line-3"></span>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="logo theme-logo">
                        <?php  
                            if ( has_custom_logo() || !empty( $vibenews_logo_url ) ) {
                            	if( isset( $vibenews_logo['url'] ) && !empty( $vibenews_logo_url ) ) { 
                            		?>
                        <a href="<?php echo esc_url( site_url('/')) ?>" class="logo">
                        <img class="img-fluid" src="<?php echo esc_url( $vibenews_logo_url ); ?>" alt="<?php echo esc_attr( $vibenews_logo_alt  ) ?>">
                        </a>
                        <?php 
                            } else {
                            	 the_custom_logo();
                            }
                            
                            } else {
                            printf('<h1 class="text-logo"><a href="%1$s">%2$s</a></h1>',esc_url(site_url('/')),esc_html(get_bloginfo('name')));
                            }
                            ?>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="header-right-content text-right">

                        <?php if($darkmode_enable == true) :?>
                            <div class="mode-switcher">
                                <i class="ifont mode-icon-change"></i>
                            </div>
                        <?php endif; ?>

                        <div class="header_search_wrap">
                            <div class="search-icon theme-search-custom-iconn"><i class="icofont-search-1"></i></div>
                            <div id="theme-serach-box_Inner">
                                <div class="theme-serach-box_inner_wrapper d-flex align-items-center">
                                    <form role="search" method="get" id="searchform" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                                        <div class="form-group">
                                            <input type="text" class="search-input" id="popup-search" value="<?php echo get_search_query(); ?>" name="s" placeholder="<?php esc_attr_e('Type keywords here.....','vibenews'); ?>" required />
                                        </div>
                                        <button type="submit" id="serach-popup-btn-box" class="search-button submit-btn"><i class="icofont-search-1"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="theme-navigation-area">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="nav-menu-wrapper">
                        <div class="nav-wrapp-one">
                            <div class="vibenews-responsive-menu"></div>
                            <div class="mainmenu">
                                <?php
                                    wp_nav_menu( array(
                                    	'theme_location' => 'primary',
                                    	'container' => 'nav',
                                    	'container_class' => 'nav-main-wrap',
                                    	'menu_class' => 'theme-main-menu',
                                    	'menu_id'        => 'primary-menu',
                                    	'fallback_cb'  => 'vibenews_fallback_menu',
                                    ) );
                                    ?>
                            </div>
                        </div>
                    </div>
                </div>
   
				
            </div>
			
			         <div class="header-user-wrap header-two-user-box">
                        <?php if($login_btn_enable == true) :?>
                        <div class="header-user-inner">
                            <a href="<?php echo esc_url( wp_registration_url() ); ?>" class="theme-user-thumb"></a>
                        </div>
                        <?php endif; ?>
                    </div>
			
			
        </div>
    </div>
</header>
<!-- Panel Nav Content -->
<div class="vibenews-custom-panel-menu-wrapper">
    <div class="vibenews-custom-panel-box-wrap">
        <div class="vibenews-custom-panel-box-effect text-right">
            <div class="vibenews-custom-panel-close">
                <span class="vibenews-custom-panelclose-letter"><?php esc_html_e( 'Close', 'vibenews' ); ?><i class="ri-close-fill"></i></span>
            </div>
        </div>
        <div class="panel-nav-widgets-content-wrapper">
            <?php if ( is_active_sidebar( 'panel-nav' ) ): ?>
            <div class="panel_nav_Widget">
                <?php dynamic_sidebar( 'panel-nav' ); ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<div class="overlay"></div>
<!-- Panel Nav Content End -->