<?php
/*
 * Theme Options
 * @package Vibenews
 * @since 1.0.0
 * */

if (!defined('ABSPATH'))
{
    exit(); // exit if access directly
    
}

if (class_exists('CSF'))
{

    //
    // Set a unique slug-like ID
    $prefix = 'vibenews';

    //
    // Create options
    CSF::createOptions($prefix . '_theme_options', array(
        'menu_title' => esc_html__('Theme Option', 'vibenews') ,
        'menu_slug' => 'vibenews-theme-option',
        'menu_type' => 'menu',
        'enqueue_webfont' => true,
        'show_footer' => false,
        'framework_title' => esc_html__('Vibenews Theme Options', 'vibenews') ,
    ));

    //
    // Create a section
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('General', 'vibenews') ,
        'icon' => 'fa fa-wrench',
        'fields' => array(

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Site Logo', 'vibenews') . '</h3>',
            ) ,

            array(
                'id' => 'theme_logo',
                'title' => esc_html__('Main Logo', 'vibenews') ,
                'type' => 'media',
                'library' => 'image',
                'desc' => esc_html__('Upload Your Static Logo Image on Header Static', 'vibenews')
            ) ,

            array(
                'id' => 'logo_width',
                'type' => 'slider',
                'title' => esc_html__('Set Logo Width', 'vibenews') ,
                'min' => 0,
                'max' => 300,
                'step' => 1,
                'unit' => 'px',
                'default' => 102,
                'desc' => esc_html__('Set Logo Width in px. Default Width 184px.', 'vibenews') ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Preloader', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'preloader_enable',
                'title' => esc_html__('Enable Preloader', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Preloader', 'vibenews') ,
                'default' => true,
            ) ,
			
			array(
                'id' => 'preloader_letter',
                'type' => 'repeater',
                'title' => esc_html__('Set Preloader Letters', 'vibenews') ,
                'dependency' => array(
                    'preloader_enable',
                    '==',
                    'true'
                ) ,
                'fields' => array(
 
                    array(
                        'id' => 'ptext',
                        'type' => 'text',
                        'title' => esc_html__('Insert Preloader Letter', 'vibenews') ,
						'default' => esc_html__('V', 'vibenews') ,
                    ) ,

                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Back Top Options', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'back_top_enable',
                'title' => esc_html__('Scroll Top Button', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable scroll button', 'vibenews') ,
                'default' => true,
            ) ,

            array(
                'id' => 'darkmode_enable',
                'title' => esc_html__('Enable Darkmode Button', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Darkmode', 'vibenews') ,
                'default' => true,
            ) ,


        )
    ));

    /*-------------------------------------------------------
     ** Entire Site Header  Options
     --------------------------------------------------------*/

    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header', 'vibenews') ,
        'id' => 'header_options',
        'icon' => 'fa fa-header',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Layout', 'vibenews') . '</h3>'
            ) ,
            //
            // nav select
            array(
                'id' => 'nav_menu',
                'type' => 'image_select',
                'title' => esc_html__('Select Header Navigation Style', 'vibenews') ,
                'options' => array(
                    'nav-style-one' => VIBENEWS_IMG . '/admin/header-style/style1.png',
                    'nav-style-two' => VIBENEWS_IMG . '/admin/header-style/style2.png',
                    'nav-style-three' => VIBENEWS_IMG . '/admin/header-style/style3.png',
                ) ,
				'desc' => esc_html__('You can Set global Header Style from here. You can also Set individual Header Style for Each Page. Go to Page edit options bottom and You will find header style selec boxes from metabox.', 'vibenews') ,
                'default' => 'nav-style-one'
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Search Bar & Login Option', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'search_bar_enable',
                'title' => esc_html__('Search Bar Display In Header', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Search Bar', 'vibenews') ,
                'default' => true,
            ) ,

            array(
                'id' => 'panel_bar_enable',
                'title' => esc_html__('Panel bar Display In Header', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Panel Bar', 'vibenews') ,
                'default' => false,
            ) ,

            array(
                'id' => 'login_btn_enable',
                'title' => esc_html__('Login bar Display In Header', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Login Bar', 'vibenews') ,
                'default' => false,
            ) ,


            array(
                'type' => 'subheading',
                'content' =>'<h3>'.esc_html__('Header 3 Buttons','vibenews').'</h3>'
            ),
      
            array(
                'id' => 'header_three_btn1',
                'title' => esc_html__('Show Header Button 1','vibenews'),
                'type' => 'switcher',
                'default' => true,
                'desc' => esc_html__('This Buttons for Header Template 3', 'vibenews') ,
            ),

            
            array(
                'id'         => 'header_three_btn1_text',
                'type'       => 'text',
                'title'      => esc_html__('Button Text','vibenews'),
                'default'    => esc_html__('Log In','vibenews'),
                'desc'       => esc_html__('Type login button text','vibenews'),
                'dependency' => array( 'header_three_btn1', '==', 'true' ),
            ),

            
            array(
                'id'         => 'header_three_btn1_link',
                'type'       => 'text',
                'title'      => esc_html__('Button Link','vibenews'),
                'default'    => esc_html__('#','vibenews'),
                'desc'       => esc_html__('Insert Button Link','vibenews'),
                'dependency' => array( 'header_three_btn1', '==', 'true' ),
            ),   

            array(
                'id' => 'header_three_btn2',
                'title' => esc_html__('Show Header Button 2','vibenews'),
                'type' => 'switcher',
                'default' => true,
                'desc' => esc_html__('This Buttons for Header Template 3', 'vibenews') ,
            ),

            
            array(
                'id'         => 'header_three_btn2_text',
                'type'       => 'text',
                'title'      => esc_html__('Button Text','vibenews'),
                'default'    => esc_html__('Subscribe','vibenews'),
                'desc'       => esc_html__('Type login button text','vibenews'),
                'dependency' => array( 'header_three_btn2', '==', 'true' ),
            ),

            
            array(
                'id'         => 'header_three_btn2_link',
                'type'       => 'text',
                'title'      => esc_html__('Button Link','vibenews'),
                'default'    => esc_html__('#','vibenews'),
                'desc'       => esc_html__('Insert Button Link','vibenews'),
                'dependency' => array( 'header_three_btn2', '==', 'true' ),
            ), 

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Social Options', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'header_social_enable',
                'title' => esc_html__('Do You want to Show Header Social Icons', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Social Bar', 'vibenews') ,
                'default' => false,
            ) ,

            array(
                'id' => 'social-icon',
                'type' => 'repeater',
                'title' => esc_html__('Repeater', 'vibenews') ,
                'dependency' => array(
                    'header_social_enable',
                    '==',
                    'true'
                ) ,
                'fields' => array(
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Pick Up Your Social Icon', 'vibenews') ,
                    ) ,
                    array(
                        'id' => 'link',
                        'type' => 'text',
                        'title' => esc_html__('Inter Social Url', 'vibenews') ,
                    ) ,

                ) ,
            ) ,

        )
    ));

    /*-------------------------------------
     ** Typography Options
     -------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Typography', 'vibenews') ,
        'id' => 'typography_options',
        'icon' => 'fa fa-font',
        'fields' => array(

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Body', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'body-typography',
                'type' => 'typography',
                'output' => 'body',
                'default' => array(
                    'color' => '#555555',
                    'font-family' => 'Roboto',
                    'font-weight' => '400',
                    'font-size' => '16',
                    'line-height' => '26',
                    'letter-spacing' => false,
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                ) ,

            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h1', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'heading-one-typo',
                'type' => 'typography',

                'output' => 'h1',
                'default' => array(
                    'color' => '#000000',
                    'font-family' => 'Oswald',
                    'font-weight' => '700',
                    'font-size' => '42',
                    'line-height' => '50',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h2', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'heading-two-typo',
                'type' => 'typography',

                'output' => 'h2',
                'default' => array(
                    'color' => '#000000',
                    'font-family' => 'Oswald',
                    'font-weight' => '700',
                    'font-size' => '28',
                    'line-height' => '36',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h3', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'heading-three-typo',
                'type' => 'typography',

                'output' => 'h3',
                'default' => array(
                    'color' => '#000000',
                    'font-family' => 'Oswald',
                    'font-weight' => '700',
                    'font-size' => '24',
                    'line-height' => '28',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h4', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'heading-four-typo',
                'type' => 'typography',

                'output' => 'h4',
                'default' => array(
                    'color' => '#000000',
                    'font-family' => 'Oswald',
                    'font-weight' => '700',
                    'font-size' => '18',
                    'line-height' => '28',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h5', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'heading-five-typo',
                'type' => 'typography',

                'output' => 'h5',
                'default' => array(
                    'color' => '#000000',
                    'font-family' => 'Oswald',
                    'font-weight' => '700',
                    'font-size' => '14',
                    'line-height' => '24',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h6', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'heading-six-typo',
                'type' => 'typography',
                'output' => 'h6',
                'default' => array(
                    'color' => '#000000',
                    'font-family' => 'Oswald',
                    'font-weight' => '700',
                    'font-size' => '14',
                    'line-height' => '28',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

        )
    ));

    /*-------------------------------------------------------
     ** Pages and Template
     --------------------------------------------------------*/

    // blog optoins
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Blog', 'vibenews') ,
        'id' => 'blog_page',
        'icon' => 'fa fa-bookmark',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Blog Options', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'blog_title',
                'type' => 'text',
                'title' => esc_html__('Blog Page Title', 'vibenews') ,
                'default' => esc_html__('Blog Page', 'vibenews') ,
                'desc' => esc_html__('Type Blog Page Title', 'vibenews') ,
            ) ,

            array(
                'id' => 'page-spacing-blog',
                'type' => 'spacing',
                'title' => esc_html__('Blog Page Spacing', 'vibenews') ,
                'output' => '.main-container.blog-spacing',
                'output_mode' => 'padding', // or margin, relative
                'default' => array(
                    'top' => '80',
                    'right' => '0',
                    'bottom' => '80',
                    'left' => '0',
                    'unit' => 'px',
                ) ,
            ) ,

            array(
                'id' => 'blog_breadcrumb_enable',
                'title' => esc_html__('Breadcrumb', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable Breadcrumb', 'vibenews') ,
                'default' => true,
            ) ,

        )
    ));

    // category
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Category', 'vibenews') ,
        'id' => 'cat_page',
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Theme Category Options. You can Customize Each Catgeory by Editing Individually.', 'vibenews') . '</h3>'
            ) ,
            array(
                'id' => 'vibenews_cat_layout',
                'type' => 'image_select',
                'title' => esc_html__('Select Category Layout', 'vibenews') ,
                'options' => array(
                    'catt-one' => VIBENEWS_IMG . '/admin/page/style1.png',
                    'catt-two' => VIBENEWS_IMG . '/admin/page/style2.png',
                ) ,
                'default' => 'catt-one'
            ) ,

            array(
                'id' => 'page-spacing-category',
                'type' => 'spacing',
                'title' => esc_html__('Category Page Spacing', 'vibenews') ,
                'output' => '.main-container.cat-page-spacing',
                'output_mode' => 'padding', // or margin, relative
                'default' => array(
                    'top' => '80',
                    'right' => '0',
                    'bottom' => '80',
                    'left' => '0',
                    'unit' => 'px',
                ) ,
            ) ,

        )
    ));

    // blog single optoins
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Single', 'vibenews') ,
        'id' => 'single_page',
        'icon' => 'fa fa-pencil-square-o',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Blog Single Page Option', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'vibenews_single_blog_layout',
                'type' => 'image_select',
                'title' => esc_html__('Select Single Blog Style', 'vibenews') ,
                'options' => array(
                    'single-one' => VIBENEWS_IMG . '/admin/page/blog-1.png',
                    'single-two' => VIBENEWS_IMG . '/admin/page/blog-2.png',
                    'single-three' => VIBENEWS_IMG . '/admin/page/blog-3.png',
                    'single-four' => VIBENEWS_IMG . '/admin/page/blog-4.png',
					'single-five' => VIBENEWS_IMG . '/admin/page/blog-5.png',
                ) ,
                'default' => 'single-one'
            ) ,

            array(
                'id' => 'page-spacing-single',
                'type' => 'spacing',
                'title' => esc_html__('Single Blog Spacing', 'vibenews') ,
                'output' => '.single-one-bwrap',
                'output_mode' => 'padding', // or margin, relative
                'default' => array(
                    'top' => '40',
                    'right' => '0',
                    'bottom' => '80',
                    'left' => '0',
                    'unit' => 'px',
                ) ,
            ) ,

            array(
                'id' => 'blog_prev_title',
                'type' => 'text',
                'title' => esc_html__('Previous Post Text', 'vibenews') ,
                'default' => esc_html__('Prev Post', 'vibenews') ,
                'desc' => esc_html__('Type Previous Post Link Title', 'vibenews') ,
            ) ,

            array(
                'id' => 'blog_next_title',
                'type' => 'text',
                'title' => esc_html__('Next Post Text', 'vibenews') ,
                'default' => esc_html__('Next Post', 'vibenews') ,
                'desc' => esc_html__('Type Next Post Link Title', 'vibenews') ,
            ) ,
			
			array(
                'id' => 'blog_single_excerpt_small',
                'title' => esc_html__('Show Small Excerpt box', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Show Excerpt Box', 'vibenews') ,
                'default' => false,
            ) ,
			
            array(
                'id' => 'blog_single_cat',
                'title' => esc_html__('Show Catgeory', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Show Category Name', 'vibenews') ,
                'default' => true,
            ) ,

            array(
                'id' => 'blog_single_author',
                'title' => esc_html__('Show Author', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Single Post Author', 'vibenews') ,
                'default' => true,
            ) ,

            array(
                'id' => 'blog_nav',
                'title' => esc_html__('Show Navigation', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Post Navigation', 'vibenews') ,
                'default' => true,
            ) ,

            array(
                'id' => 'blog_tags',
                'title' => esc_html__('Show Tags', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Show Post Tags', 'vibenews') ,
                'default' => true,
            ) ,

            array(
                'id' => 'blog_related',
                'title' => esc_html__('Show Related Posts', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Related Posts', 'vibenews') ,
                'default' => true,
            ) ,

            array(
                'id' => 'blog_views',
                'title' => esc_html__('Show Post Views', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Post views', 'vibenews') ,
                'default' => false,
            ) ,

        )
    ));
	
	/*-------------------------------------------------------
       ** Woocommerce  Options
    --------------------------------------------------------*/
    
  CSF::createSection( $prefix.'_theme_options', array(
    'title'  => esc_html__('Shop','vibenews'),
    'id' => 'cat_page',
    'icon' => 'fa fa-pencil-square-o',
    'fields' => array(
      array(
        'type' => 'subheading',
        'content' => '<h3>' . esc_html__('Shop Layout', 'vibenews') . '</h3>'
      ),
      
      
        array(
            'id' => 'shop_layout',
            'type' => 'image_select',
            'title' => esc_html__('Shop Layout','vibenews'),
            'options' => array(
             
                'right-sidebar' => VIBENEWS_IMG . '/admin/header-style/R.png',
                'left-sidebar' => VIBENEWS_IMG . '/admin/header-style/L.png',
                'no-sidebar' => VIBENEWS_IMG . '/admin/header-style/D.png',
            ),
            
            'default' => 'right-sidebar'
        ),
        

        array(
            'id'         => 'product_page_title',
            'type'       => 'text',
            'title'      => esc_html__('Poduct Page Title Text','vibenews'),
            'default'    => esc_html__('Product Details','vibenews'),
            'desc'       => esc_html__('Give Product Page Title Text','vibenews'),
        ),


		)
	)); 
	
    /*-------------------------------------------------------
     ** Footer  Options
     --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Footer', 'vibenews') ,
        'id' => 'footer_options',
        'icon' => 'fa fa-copyright',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'vibenews') . '</h3>'
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Logo', 'vibenews') . '</h3>',
            ) ,

            array(
                'id' => 'theme_logo_footer',
                'title' => esc_html__('Footer Logo', 'vibenews') ,
                'type' => 'media',
                'library' => 'image',
                'desc' => esc_html__('Upload Your Footer Logo Image', 'vibenews')
            ) ,

            array(
                'id' => 'footer_social_enable',
                'title' => esc_html__('Do You want to Show Footer Social Icons', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Social Bar', 'vibenews') ,
                'default' => false,
            ) ,

            array(
                'id' => 'fsocial-icon',
                'type' => 'repeater',
                'title' => esc_html__('Repeater', 'vibenews') ,
                'dependency' => array(
                    'footer_social_enable',
                    '==',
                    'true'
                ) ,
                'fields' => array(
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Pick Up Your Social Icon', 'vibenews') ,
                    ) ,
                    array(
                        'id' => 'link',
                        'type' => 'text',
                        'title' => esc_html__('Inter Social Url', 'vibenews') ,
                    ) ,

                ) ,
            ) ,

            array(
                'id' => 'footer_nav',
                'title' => esc_html__('Footer Right Menu', 'vibenews') ,
                'type' => 'switcher',
                'desc' => esc_html__('You can set Yes or No to show Footer menu', 'vibenews') ,
                'default' => false,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Copyright Area Options', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'copyright_text',
                'title' => esc_html__('Copyright Area Text', 'vibenews') ,
                'type' => 'textarea',
                'desc' => esc_html__('Footer Copyright Text', 'vibenews') ,
            ) ,

        )
    ));

    // Backup section
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Backup', 'vibenews') ,
        'id' => 'backup_options',
        'icon' => 'fa fa-window-restore',
        'fields' => array(
            array(
                'type' => 'backup',
            ) ,
        )
    ));

}

