<?php
/*
 * Theme Metabox
 * @package Vibenews
 * @since 1.0.0
 * */

if ( !defined('ABSPATH') ){
    exit(); // exit if access directly
}

if ( class_exists('CSF') ){

    $prefix = 'vibenews';

	/*-------------------------------------
		Category Taxonomy Options
	-------------------------------------*/
	
	
// Create taxonomy options
  CSF::createTaxonomyOptions( $prefix, array(
	'title'     => esc_html__('Catgeory Options','vibenews'),
    'taxonomy'  => 'category',
    'data_type' => 'serialize', // The type of the database save options. `serialize` or `unserialize`
  ) );

  //
  // Create a section
  CSF::createSection( $prefix, array(
    'fields' => array(

	array(
	
	  'id'          => 'cat-color',
	  'type'        => 'color',
	  'title'       => esc_html__('Select Category Color','vibenews'),
	  'default' => '#ffbc00',
	  	  
	),
	
	array(
	  'id'    => 'cat-bg',
	  'type'  => 'upload',
	  'title' => esc_html__('Upload','vibenews'),
	),

	   array(
		'id' => 'vibenews_cat_layout',
		'type' => 'image_select',
		'title' => esc_html__('Select Category Layout','vibenews'),
		'options' => array(
			'catt-one' => VIBENEWS_IMG . '/admin/page/style1.png',
			'catt-two' => VIBENEWS_IMG . '/admin/page/style2.png',
		),
		'default' => 'catt-one'
	),

    )
  ) );
	
	
	/*-------------------------------------
		Post Format Options
	-------------------------------------*/
	CSF::createMetabox('theme_postvideo_options',array(
		'title' => esc_html__('Video Post Format Options','vibenews'),
		'post_type' => 'post',
		'post_formats' => 'video',
		'data_type'          => 'serialize',
		'context'            => 'advanced',
		'priority'           => 'default',
	));
	
	CSF::createSection('theme_postvideo_options',array(
		'fields' => array(
			array(
				'id' => 'textm',
				'type' => 'text',
				'title' => esc_html__('Upload Video For Post','vibenews'),
				'desc' => esc_html__('Upload Video Post','vibenews'),
			)
		)
	));

	
	/*-------------------------------------
       Page Options
   -------------------------------------*/
   	  $post_metabox = 'vibenews_post_meta';
	  
	  CSF::createMetabox( $post_metabox, array(
	    'title'     => esc_html__('Page Options','vibenews'),
	    'post_type' => 'page',
	  ) );

	  //
	  // Create a section
	  CSF::createSection( $post_metabox, array(
	    'title'  => 'Nav Menu Option',
	    'fields' => array(
	     array(
                'type'    => 'subheading',
                'content' => esc_html__('Nav Menu Option','vibenews'),
	       ),
	      //
		
		array(
            'id' => 'nav_menu',
            'type' => 'image_select',
            'title' => esc_html__('Select Header Navigation Style','vibenews'),
            'options' => array(
                'nav-style-one' => VIBENEWS_IMG . '/admin/header-style/style1.png',
                'nav-style-two' => VIBENEWS_IMG . '/admin/header-style/style2.png',
                'nav-style-three' => VIBENEWS_IMG . '/admin/header-style/style3.png',
            ),
            'default' => 'nav-style-one'
        ),
		
		
		array(
			'id' => 'page_title_enable',
			'title' => esc_html__('Show Page Title','vibenews'),
			'type' => 'switcher',
			'default' => true,
			'desc' => esc_html__('Show Page Title Bar', 'vibenews') ,
		),
		
		
		array(
			'id' => 'page-spacing-padding',
			'type' => 'spacing',
			'title' => esc_html__('Theme Page Spacing', 'vibenews') ,
			'output' => 'body.page .main-container',
			'output_mode' => 'padding', // or margin, relative
			'default' => array(
				'top' => '80',
				'right' => '0',
				'bottom' => '80',
				'left' => '0',
				'unit' => 'px',
			) ,
		) ,
		
		
		
		
		

	    )
	  ) );	
	  
	/*-------------------------------------
       Post Options
   -------------------------------------*/
   	  $single_blog_metabox = 'vibenews_blog_post_meta';
	  
	  CSF::createMetabox( $single_blog_metabox, array(
	    'title'     => esc_html__('Post Options', 'vibenews') ,
	    'post_type' => 'post',
	  ) );

	  //
	  // Create a section
	  CSF::createSection( $single_blog_metabox, array(
	    'title'  => esc_html__('Single Post Layout Option', 'vibenews') ,
	    'fields' => array(
	     array(
                'type'    => 'subheading',
                'content' => esc_html__('Single Post Layout Option','vibenews'),
	       ),
	      //
		
		array(
				'id' => 'vibenews_single_blog_layout',
				'type' => 'image_select',
				'title' => esc_html__('Select Single Blog Style','vibenews'),
				'options' => array(
                    'single-one' => VIBENEWS_IMG . '/admin/page/blog-1.png',
                    'single-two' => VIBENEWS_IMG . '/admin/page/blog-2.png',
                    'single-three' => VIBENEWS_IMG . '/admin/page/blog-3.png',
                    'single-four' => VIBENEWS_IMG . '/admin/page/blog-4.png',
					'single-five' => VIBENEWS_IMG . '/admin/page/blog-5.png',
                ) ,
				'default' => 'single-one'
			),
		

	    )
	  ) );	
	  





}//endif