<?php
if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly
	
}

if (!function_exists('vibenews_theme_inline_style')):

	function vibenews_theme_inline_style()
	{

		wp_enqueue_style('vibenews-custom-style', get_template_directory_uri() . '/assets/css/custom-style.css');
		
		$theme_main_color = vibenews_get_customize_option('theme_main_color');
		$theme_secondary_color = vibenews_get_customize_option('theme_secondary_color');

		$custom_css = '';
		
		
		if (!empty($theme_main_color))

		{
			
			$custom_css .= '.lv-header-bar-1 .panel-bar-box:hover .lv-header-bar-line, .backto, .wp-block-search .wp-block-search__button, .nav-menu-wrapper .mainmenu ul>li:hover>a::before, .video-play-icon-wrap a {background-color: ' . esc_attr($theme_main_color) . '!important;}';
				
				$custom_css .= '.search-icon.theme-search-custom-iconn:hover, .nav-menu-wrapper .mainmenu ul>li.menu-item-has-children>a:hover:after {color: ' . esc_attr($theme_main_color) . '!important;}';
				
				$custom_css .= '.wp-block-search .wp-block-search__button, #theme-serach-box_Inner .theme-serach-box_inner_wrapper input {border-color: ' . esc_attr($theme_main_color) . '!important;}';
		}

		if (!empty($theme_secondary_color))

		{
			
			$custom_css .= '.backto:hover, .widget_block.widget_search .wp-block-search__button:hover, .see-all-btn a:hover, .theme-latest-post-block-wrapper .post-time-box:before, .news_tab_Block .nav-tabs .nav-link.active, .blog-sidebar .widget ul li::before, .main-container .theme-pagination-style ul.page-numbers li span.current, .main-container .theme-pagination-style ul.page-numbers li a.page-numbers:hover, .blog-post-comment .comment-respond .comment-form .btn-comments:hover, .woocommerce ul.products li.product .add_to_cart_button, .woocommerce-page ul.products li.product .add_to_cart_button, .wc-block-product-search .wc-block-product-search__button, .woocommerce span.onsale, .woocommerce-mini-cart__buttons a.button.wc-forward, .woocommerce-mini-cart__buttons a.button.checkout:hover, nav.wc-pagination ul.page-pagination li span.current, nav.wc-pagination ul.page-pagination li a.page-numbers:hover, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce input.button, .woocommerce button.button.alt.disabled {background-color: ' . esc_attr($theme_secondary_color) . '!important;}';

			$custom_css .= '.see-all-btn a, .main-container .theme-pagination-style ul.page-numbers li i, .blog-details-content ul li::marker, .theme_blog_nav_Label, .theme_blog_nav_Title a:hover, .blog-post-comment .comment-respond .comment-form .btn-comments, .blog-post-comment .comment-respond p.logged-in-as a, .woocommerce ul.products li.product .woocommerce-loop-product__title a:hover, .woocommerce-page ul.products li.product .woocommerce-loop-product__title a:hover, .woocommerce-info a.showcoupon, .woocommerce-info:before {color: ' . esc_attr($theme_secondary_color) . '!important;}';			
				
			$custom_css .= '.widget_block.widget_search .wp-block-search__button:hover, .see-all-btn a, .main-container .theme-pagination-style ul.page-numbers li span.current, .main-container .theme-pagination-style ul.page-numbers li a.page-numbers:hover, .blog-post-comment .comment-respond .comment-form .btn-comments, nav.wc-pagination ul.page-pagination li span.current, nav.wc-pagination ul.page-pagination li a.page-numbers:hover, .woocommerce-info {border-color: ' . esc_attr($theme_secondary_color) . '!important;}';

		}


		// Get Category Color for List Widget
		
		$categories_widget_color = get_terms('category');
		
        if ($categories_widget_color) {
            foreach( $categories_widget_color as $tag) {
				$tag_link = get_category_link($tag->term_id);
				$title_bg_Color = get_term_meta($tag->term_id, 'vibenews', true);
				$catColor = !empty( $title_bg_Color['cat-color'] )? $title_bg_Color['cat-color'] : '#FFFFFF';
				$custom_css .= '
					.cat-item-'.$tag->term_id.' span.post_count {background-color : '.$catColor.' !important;} 
				';
			}
        }	
		
		
	
				


		wp_add_inline_style('vibenews-custom-style', $custom_css);
	}
	add_action('wp_enqueue_scripts', 'vibenews_theme_inline_style');

endif;

