<?php

/*
 * Theme Customize Options
 * @package vibenews
 * @since 1.0.0
 * */

if ( !defined('ABSPATH') ){
	exit(); // exit if access directly
}

if (class_exists('CSF') ){
	$prefix = 'vibenews';

	CSF::createCustomizeOptions($prefix.'_customize_options');


	/*-------------------------------------
     ** Color Settings
     -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
		'id' => 'theme_settings', // Set a unique slug-like ID
        'title' => esc_html__('Vibenews Color Settings', 'vibenews') ,
        'priority' => 10,
        'fields' => array(

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Choose Theme Color', 'vibenews') . '</h3>',
            ) ,

            array(
                'id' => 'theme_main_color',
                'type' => 'color',
                'title' => esc_html__('Theme Main Color', 'vibenews') ,
                'default' => '#0AF8C5',
            ) ,

            array(
                'id' => 'theme_secondary_color',
                'type' => 'color',
                'title' => esc_html__('Theme Secondary Color', 'vibenews') ,
                'default' => '#2660ff',
            ) ,
   

            array(
                'id' => 'theme_body_bg',
                'type' => 'color',
                'title' => esc_html__('Body Background Color', 'vibenews') ,
                'default' => '#fff',
				'output'      => 'body',
				'output_mode' => 'background-color'
				
            ) ,

            array(
                'id' => 'theme_body_text',
                'type' => 'color',
                'title' => esc_html__('Body Text Color', 'vibenews') ,
                'default' => '#555555',
				'output'      => 'body',
				'output_mode' => 'color'
            ) ,
			
		
            array(
                'id' => 'theme_header_bg',
                'type' => 'color',
                'title' => esc_html__('Header Background Color', 'vibenews') ,
                'default' => '#000000',
                'output'      => '.theme-logo-area',
                'output_mode' => 'background'
                
            ) ,

            array(
                'id' => 'theme_header_icon_panel_nav_color',
                'type' => 'color',
                'title' => esc_html__('Header Panel Menu Icon Color', 'vibenews') ,
                'default' => '#5A5A5A',
                'output'      => '.lv-header-bar-line',
                'output_mode' => 'background-color'
            ) ,

            array(
                'id' => 'theme_header_icon_search_color',
                'type' => 'color',
                'title' => esc_html__('Header Search Icon Color', 'vibenews') ,
                'default' => '#404040',
                'output'      => '.search-icon.theme-search-custom-iconn',
                'output_mode' => 'color'
            ) ,

            array(
                'id' => 'theme_header_dark_switcher__color',
                'type' => 'color',
                'title' => esc_html__('Header Dark Mode Switcher Color', 'vibenews') ,
                'default' => '#555555',
                'output'      => '.mode-switcher',
                'output_mode' => 'color'
            ) ,
			
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer', 'vibenews') . '</h3>'
            ) ,

            array(
                'id' => 'theme_footer_bg',
                'type' => 'color',
                'title' => esc_html__('Footer Background Color', 'vibenews') ,
                'default' => '#000000',
                'output'      => 'footer.theme-footer-wrapper',
                'output_mode' => 'background'
                
            ) ,

            array(
                'id' => 'footer_copyright_text',
                'type' => 'color',
                'title' => esc_html__('Footer Copyright Text Color', 'vibenews') ,
                'default' => '#797979',
                'output'      => 'p.copyright-text',
                'output_mode' => 'color'
            ) ,
			

        )

    ));






}//endif