<?php
/**
 * Vibenews functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package vibenews
 */


/**
 * define theme info
 * @since 1.0.0
 * */
 
 if (is_child_theme()){
	$theme = wp_get_theme();
	$parent_theme = $theme->Template;
	$theme_info = wp_get_theme($parent_theme);
}else{
	$theme_info = wp_get_theme();
}

define('VIBENEWS_DEV_MODE',true);
$vibenews_version = VIBENEWS_DEV_MODE ? time() : $theme_info->get('Version');
define('VIBENEWS_NAME',$theme_info->get('Name'));
define('VIBENEWS_VERSION',$vibenews_version);
define('VIBENEWS_AUTHOR',$theme_info->get('Author'));
define('VIBENEWS_AUTHOR_URI',$theme_info->get('AuthorURI'));


/**
 * Define Const for theme Dir
 * @since 1.0.0
 * */

define('VIBENEWS_THEME_URI', get_template_directory_uri());
define('VIBENEWS_IMG', VIBENEWS_THEME_URI . '/assets/images');
define('VIBENEWS_CSS', VIBENEWS_THEME_URI . '/assets/css');
define('VIBENEWS_JS', VIBENEWS_THEME_URI . '/assets/js');
define('VIBENEWS_THEME_DIR', get_template_directory());
define('VIBENEWS_IMG_DIR', VIBENEWS_THEME_DIR . '/assets/images');
define('VIBENEWS_CSS_DIR', VIBENEWS_THEME_DIR . '/assets/css');
define('VIBENEWS_JS_DIR', VIBENEWS_THEME_DIR . '/assets/js');
define('VIBENEWS_INC', VIBENEWS_THEME_DIR . '/inc');
define('VIBENEWS_THEME_OPTIONS',VIBENEWS_INC .'/theme-options');
define('VIBENEWS_THEME_OPTIONS_IMG',VIBENEWS_THEME_OPTIONS .'/img');

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
*/
	 
function vibenews_setup(){
	
	// make the theme available for translation
	load_theme_textdomain( 'vibenews', get_template_directory() . '/languages' );
	
	// add support for post formats
    add_theme_support('post-formats', [
        'standard', 'image', 'video', 'audio','gallery'
    ]);

    // add support for automatic feed links
    add_theme_support('automatic-feed-links');

    // let WordPress manage the document title
    add_theme_support('title-tag');
	
	// add editor style theme support
	function vibenews_theme_add_editor_styles() {
		add_editor_style( 'custom-style.css' );
	}
	add_action( 'admin_init', 'vibenews_theme_add_editor_styles' );

    // add support for post thumbnails
    add_theme_support('post-thumbnails');
	
	// hard crop center center
    set_post_thumbnail_size(770, 470, ['center', 'center']);
	add_image_size( 'vibenews-box-slider-small', 96, 96, true );
	
	
	// register navigation menus
    register_nav_menus(
        [
            'primary' => esc_html__('Primary Menu', 'vibenews'),
            'footermenu' => esc_html__('Footer Menu', 'vibenews'),
        ]
    );
	
	
	// HTML5 markup support for search form, comment form, and comments
    add_theme_support('html5', array(
        'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
    ));
	
	
	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support( 'custom-logo', array(
		'height'      => 150,
		'width'       => 300,
		'flex-width'  => true,
		'flex-height' => true,
	) );
	
	
	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	
	/*
     * Enable support for wide alignment class for Gutenberg blocks.
     */
    add_theme_support( 'align-wide' );
    add_theme_support( 'editor-styles' );
    add_theme_support( 'wp-block-styles' );
		
}

add_action('after_setup_theme', 'vibenews_setup');

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
*/
 
function vibenews_widget_init() {
	

        register_sidebar( array (
			'name' => esc_html__('Blog widget area', 'vibenews'),
			'id' => 'sidebar-1',
			'description' => esc_html__('Blog Sidebar Widget.', 'vibenews'),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h3 class="widget-title">',
			'after_title' => '</h3>',
			
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area One', 'vibenews' ),
			'id'            => 'footer-widget-1',
			'description'   => esc_html__( 'Add Footer  widgets here.', 'vibenews' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area Two', 'vibenews' ),
			'id'            => 'footer-widget-2',
			'description'   => esc_html__( 'Add Footer widgets here.', 'vibenews' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area Three', 'vibenews' ),
			'id'            => 'footer-widget-3',
			'description'   => esc_html__( 'Add Footer widgets here.', 'vibenews' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area Four', 'vibenews' ),
			'id'            => 'footer-widget-4',
			'description'   => esc_html__( 'Add Footer widgets here.', 'vibenews' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area Five', 'vibenews' ),
			'id'            => 'footer-widget-5',
			'description'   => esc_html__( 'Add Footer widgets here.', 'vibenews' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area Six', 'vibenews' ),
			'id'            => 'footer-widget-6',
			'description'   => esc_html__( 'Add Footer widgets here.', 'vibenews' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );		
		
		register_sidebar( array(
			'name'          => esc_html__( 'Panel Menu Widget Area', 'vibenews' ),
			'id'            => 'panel-nav',
			'description'   => esc_html__( 'Add Panel Nav widgets here.', 'vibenews' ),
			'before_widget' => '<div id="%1$s" class="panel-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );
		
		
					
}

add_action('widgets_init', 'vibenews_widget_init');


/**
 * Enqueue scripts and styles.
 */
function vibenews_scripts() {

	wp_enqueue_style( 'font-awesome-lib', VIBENEWS_CSS . '/font-awesome.css');
	wp_enqueue_style( 'icon-font',  VIBENEWS_CSS . '/icon-font.css' );
	wp_enqueue_style( 'remix-icon',  VIBENEWS_CSS . '/remixicon.css' );
	wp_enqueue_style( 'animate',  VIBENEWS_CSS . '/animate.css' );
	wp_enqueue_style( 'magnific-popup',  VIBENEWS_CSS . '/magnific-popup.css' );
	wp_enqueue_style( 'owl-carousel',  VIBENEWS_CSS . '/owl.carousel.min.css' );
	wp_enqueue_style( 'owl-theme',  VIBENEWS_CSS . '/owl.theme.min.css' );
	wp_enqueue_style( 'slick',  VIBENEWS_CSS . '/slick.css' );
	wp_enqueue_style( 'slicknav',  VIBENEWS_CSS . '/slicknav.css' );
	wp_enqueue_style( 'swiper',  VIBENEWS_CSS . '/swiper.min.css' );
	wp_enqueue_style( 'flickity',  VIBENEWS_CSS . '/flickity.min.css' );

   // theme css
	

	if (is_rtl()) {
		wp_enqueue_style( 'bootstrap', VIBENEWS_CSS . '/bootstrap.min.css', array(), '4.0', 'all');
		wp_enqueue_style( 'theme-fonts', VIBENEWS_CSS . '/theme-fonts.css', array(), '1.0', 'all');
		wp_enqueue_style( 'vibenews-main',  VIBENEWS_CSS . '/main.css' );
		wp_enqueue_style( 'vibenews-rtl',  VIBENEWS_CSS . '/rtl.css' );
		wp_enqueue_style( 'vibenews-responsive',  VIBENEWS_CSS . '/responsive.css' );
		
	} else {
		wp_enqueue_style( 'bootstrap', VIBENEWS_CSS . '/bootstrap.min.css', array(), '4.0', 'all');
		wp_enqueue_style( 'theme-fonts', VIBENEWS_CSS . '/theme-fonts.css', array(), '1.0', 'all');
		wp_enqueue_style( 'vibenews-main',  VIBENEWS_CSS . '/main.css' );
		wp_enqueue_style( 'vibenews-responsive',  VIBENEWS_CSS . '/responsive.css' );	
	}
	
	wp_enqueue_style( 'vibenews-style', get_stylesheet_uri() );

	
	wp_enqueue_script( 'bootstrap',  VIBENEWS_JS . '/bootstrap.min.js', array( 'jquery' ),  '4.0', true );
	wp_enqueue_script( 'popper',  VIBENEWS_JS . '/popper.min.js', array( 'jquery' ),  '1.0', true );
	wp_enqueue_script( 'jquery-magnific-popup',  VIBENEWS_JS . '/jquery.magnific-popup.min.js', array( 'jquery' ),  '1.0', true );
	wp_enqueue_script( 'jquery-appear',  VIBENEWS_JS . '/jquery.appear.min.js', array( 'jquery' ),  '1.0', true );
	wp_enqueue_script( 'owl-carousel',  VIBENEWS_JS . '/owl.carousel.min.js', array( 'jquery' ),  '1.0', true );
	wp_enqueue_script( 'jquery-easypiechart', VIBENEWS_JS . '/jquery.easypiechart.min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'slick', VIBENEWS_JS . '/slick.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'swiper', VIBENEWS_JS . '/swiper.min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'jquery-slicknav', VIBENEWS_JS . '/jquery.slicknav.min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'jquery-flickity', VIBENEWS_JS . '/flickity.min.js', array( 'jquery' ), '1.0', true );
	
	// Custom JS Scripts
	
	wp_enqueue_script( 'vibenews-scripts',  VIBENEWS_JS . '/scripts.js', array( 'jquery' ),  '1.0', true );

	wp_localize_script( 'vibenews-scripts', 'vibenews_ajax', array(
   
	'ajax_url' => admin_url( 'admin-ajax.php' ),

	) );

	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	

}

add_action( 'wp_enqueue_scripts', 'vibenews_scripts' );


/*
* Include codester helper functions
* @since 1.0.0
*/

if ( file_exists( VIBENEWS_INC.'/cs-framework-functions.php' ) ) {
	require_once  VIBENEWS_INC.'/cs-framework-functions.php';
}

/**
 * Theme option panel & Metaboxes.
*/
 if ( file_exists( VIBENEWS_THEME_OPTIONS.'/theme-options.php' ) ) {
	require_once  VIBENEWS_THEME_OPTIONS.'/theme-options.php';
}

if ( file_exists( VIBENEWS_THEME_OPTIONS.'/theme-metabox.php' ) ) {
	require_once  VIBENEWS_THEME_OPTIONS.'/theme-metabox.php';
}

if ( file_exists( VIBENEWS_THEME_OPTIONS.'/theme-customizer.php' ) ) {
	require_once  VIBENEWS_THEME_OPTIONS.'/theme-customizer.php';
}


if ( file_exists( VIBENEWS_THEME_OPTIONS.'/theme-inline-styles.php' ) ) {
	require_once  VIBENEWS_THEME_OPTIONS.'/theme-inline-styles.php';
}


/**
 * Required plugin installer 
*/
require get_template_directory() . '/inc/required-plugins.php';


/**
 * Custom template tags & functions for this theme.
*/
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/template-functions.php';

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'woocommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
*/
function vibenews_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'vibenews_content_width', 640 );
}

add_action( 'after_setup_theme', 'vibenews_content_width', 0 );

/**
 * Nav menu fallback function
*/

function vibenews_fallback_menu() {
	get_template_part( 'template-parts/default', 'menu' );
}


function vibenews_enable_svg_upload( $upload_mimes ) {
    $upload_mimes['svg'] = 'image/svg+xml';
    $upload_mimes['svgz'] = 'image/svg+xml';
    return $upload_mimes;
}
add_filter( 'upload_mimes', 'vibenews_enable_svg_upload', 10, 1 );


function vibenews_post_time_ago_function() {
return sprintf( esc_html__( '%s ago', 'vibenews' ), human_time_diff(get_the_time ( 'U' ), current_time( 'timestamp' ) ) );
}
add_filter( 'the_time', 'vibenews_post_time_ago_function' );


/**
 * Post List Load More Function
*/

function vibenews_post_ajax_loading_cb()
{   
    $settings =  $_POST['ajax_json_data'];

   $arg = [
      'post_type'   =>  'post',
      'post_status' => 'publish',
      'order'       => $settings['order'],
      'posts_per_page' => $settings['posts_per_page'],
      'paged'             => $_POST['paged'],
      'tag__in'           => $settings['tags'],
      'suppress_filters' => false,
    
  ];

  if(count($settings['terms'])){
   $arg['tax_query'] = array(
      array(
                'taxonomy' => 'category',
                'terms'    => $settings['terms'],
                'field' => 'id',
                'include_children' => true,
                'operator' => 'IN'
        ),
    );
  }

  switch($settings['post_sortby']){

	  case 'title':
           $arg['orderby'] = 'title';
      break;
			
		
      case 'mostdiscussed':
          $arg['orderby'] = 'comment_count';
      break;
      default:
          $arg['orderby'] = 'date';
      break;
  }
   
  $allpostloding = new WP_Query($arg);
  $index = 0;

  while($allpostloding->have_posts()){ $allpostloding->the_post(); ?>
     	
	<article <?php post_class( 'post-col-common post-list-bottom loadmore-small-post grid-item' ); ?>>

		<div class="post-block-item-three">
			
			<div class="news-post-grid-thumbnail">
				<a href="<?php the_permalink(); ?>" class="news-post-grid-thumbnail-wrap">
					<img src="<?php echo esc_attr(esc_url(get_the_post_thumbnail_url(null, 'full'))); ?>" alt="<?php the_title_attribute(); ?>">
				</a>
			</div>
			
			<div class="grid-content-top post-block-item-three-inner">
			
				<div class="blog-post-meta-items post-block-meta-top">
					
					<?php if($settings['show_cat'] == 'yes'): ?>	
					<div class="post-cat-box post-block-meta-cat">
					<?php require VIBENEWS_THEME_DIR . '/template-parts/cat-color.php'; ?>
					</div>
					<?php endif; ?>	
					
					<?php if($settings['show_date'] == 'yes'): ?>
					<div class="post-date-box post-block-meta-date">
					<?php echo esc_html( get_the_date( 'F j, Y' ) ); ?>
					</div>
					<?php endif; ?>
			
				</div>
				
				<h3 class="post-title">
					<a href="<?php the_permalink(); ?>"><?php echo esc_html( wp_trim_words(get_the_title(), $settings['post_title_crop'],'') ); ?></a>
				</h3>

				<?php if($settings['show_desc'] == 'yes'): ?> 
				<div class="post-excerpt-box">
					<p><?php echo esc_html( wp_trim_words(get_the_excerpt(), $settings['desc_limit'] ,'') );?></p>
				</div>
				<?php endif; ?>

			</div>
			
		</div>

</article>


    <?php

     $index ++;
  }

  wp_reset_postdata();

  wp_die();
  
}

add_action( 'wp_ajax_nopriv_vibenews_post_ajax_loading', 'vibenews_post_ajax_loading_cb' );
add_action( 'wp_ajax_vibenews_post_ajax_loading', 'vibenews_post_ajax_loading_cb' );