<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package vibenews
 */
 
$scroll_top = vibenews_get_option('back_top_enable', true);
$footer_nav = vibenews_get_option('footer_nav');
$footer_copyright_text = vibenews_get_option('copyright_text');
$footer_copyright_text_allowed_tags = array(
    'a' => array(
        'href' => array(),
        'title' => array()
    ),
	'img' => array(
        'alt' => array(),
        'src' => array()
    ),
    'br' => array(),
    'em' => array(),
    'strong' => array(),
);


$vibenews_footer_social = vibenews_get_option('footer_social_enable', false);
$vibenews_social_icon = vibenews_get_option( 'fsocial-icon' );

$vibenews_logo = vibenews_get_option( 'theme_logo_footer' );
$vibenews_logo_id = isset($vibenews_logo['id']) && !empty($vibenews_logo['id']) ? $vibenews_logo['id'] : '';
$vibenews_logo_url = isset( $vibenews_logo[ 'url' ] ) ? $vibenews_logo[ 'url' ] : '';
$vibenews_logo_alt = get_post_meta($vibenews_logo_id,'_wp_attachment_image_alt',true);



?>

	<!-- footer area start -->
    <footer class="theme-footer-wrapper theme_footer_Widegts <?php if(is_active_sidebar('footer-widget-1')) { echo "hav-footer-topp"; } else { echo "no-footer-top";}?>">
	
		
		<div class="footer-top">
            <div class="container">
                <div class="row">
				
					<div class="col-lg-6 col-md-6">
						<div class="footer-top-wrapper">
						
							<div class="footer-top-logo">
								<?php  
								if ( has_custom_logo() || !empty( $vibenews_logo_url ) ) {
									if( isset( $vibenews_logo['url'] ) && !empty( $vibenews_logo_url ) ) { 
										?>
											<a href="<?php echo esc_url( site_url('/')) ?>" class="logo">
												<img class="img-fluid" src="<?php echo esc_url( $vibenews_logo_url ); ?>" alt="<?php echo esc_attr( $vibenews_logo_alt  ) ?>">
											</a>
										<?php 
									} else {
										 the_custom_logo();
									}

								} else {
									printf('<h1 class="text-logo"><a href="%1$s">%2$s</a></h1>',esc_url(site_url('/')),esc_html(get_bloginfo('name')));
								}
								?>
							</div>
							
							<?php if($vibenews_footer_social == true) : ?>
						
							<div class="footer-socials">
							
							<?php 
								if ( ! empty( $vibenews_social_icon ) ) : 
								foreach( $vibenews_social_icon as $item ) :
							?>
								
								<a href="<?php echo esc_url( $item['link'] ); ?>" target="_blank" class="social-list__link"><i class="<?php echo esc_attr( $item['icon'] ); ?>"></i></a>
								
							<?php 
							endforeach; 
								endif; 
							?>
						
							</div>
							
							<?php endif; ?>
						
						
						</div>
					</div>
						
	                <div class="col-lg-6 col-md-6">
					</div>
                    
                </div>
            </div>
        </div>
		
		<div class="footer-border"></div>
		
		<?php if( is_active_sidebar( 'footer-widget-1' ) ) : ?>
        <div class="footer-main">
            <div class="container">
                <div class="row custom-gutter">
				
					<?php if ( is_active_sidebar( 'footer-widget-1' ) ): ?>
                    <div class="col-lg-2 col-md-6 col-sm-6 footer_one_Widget">
                        <?php dynamic_sidebar( 'footer-widget-1' ); ?>
                    </div>
					<?php endif; ?> 
					
					<?php if ( is_active_sidebar( 'footer-widget-2' ) ): ?>
                    <div class="col-lg-2 col-md-6 col-sm-6 footer_two_Widget">
						<?php dynamic_sidebar( 'footer-widget-2' ); ?>
                    </div>
					<?php endif; ?> 
					
					<?php if ( is_active_sidebar( 'footer-widget-3' ) ): ?>
                    <div class="col-lg-2 col-md-6 col-sm-6 footer_three_Widget">
						<?php dynamic_sidebar( 'footer-widget-3' ); ?>
                    </div>
					<?php endif; ?> 
					
					<?php if ( is_active_sidebar( 'footer-widget-4' ) ): ?>
                    <div class="col-lg-2 col-md-6 col-sm-6 footer_four_Widget">
						<?php dynamic_sidebar( 'footer-widget-4' ); ?>
                    </div>
					<?php endif; ?>
					
					<?php if ( is_active_sidebar( 'footer-widget-5' ) ): ?>
                    <div class="col-lg-2 col-md-6 col-sm-6 footer_five_Widget">
						<?php dynamic_sidebar( 'footer-widget-5' ); ?>
                    </div>
					<?php endif; ?>
					
					<?php if ( is_active_sidebar( 'footer-widget-6' ) ): ?>
                    <div class="col-lg-2 col-md-6 col-sm-6 footer_six_Widget">
						<?php dynamic_sidebar( 'footer-widget-6' ); ?>
                    </div>
					<?php endif; ?>
					
					
					
                </div>
            </div>
        </div>
		<?php endif; ?>
		<div class="footer-bottom">
            <div class="container">
                <div class="row">
				
					<div class="<?php if( $footer_nav == true ) { echo "col-lg-6 col-md-6 text-left"; } else { echo "col-lg-12 col-md-12 text-center"; } ?>">
                        <p class="copyright-text">
							<?php if( !empty($footer_copyright_text) ){
								echo wp_kses($footer_copyright_text, $footer_copyright_text_allowed_tags);
							} else {
								esc_html_e('Copyright &copy; Vibenews 2023. All rights reserved', 'vibenews');
							}?>
						</p>
                    </div>
					
					<?php if($footer_nav == true) :?>
                    <div class="col-lg-6 col-md-6 text-right">
						
						<?php
                           if ( has_nav_menu( 'footermenu' ) ) {
                           
                              wp_nav_menu( array( 
                                 'theme_location' => 'footermenu', 
								 'theme_location' => 'footermenu',
                                 'menu_class' => 'footer-nav', 
                                 'container' => '' 
                              ) );
                           }

                        ?>
					</div>
					<?php endif; ?>
                    
                </div>
            </div>
        </div>
	</footer>
    <!-- footer area end -->
	
	</div>

	<?php if($scroll_top == true) :?>
	<div class="backto"> 
		<a href="#" class="icofont-long-arrow-up" aria-hidden="true"></a>
	</div>
	<?php endif; ?>
	
   <?php wp_footer(); ?>
   		
   </body>
</html>

