<?php
/**
 * The template for displaying catgeory pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vibenews
 */

get_header();

$vibenews_cat_style = get_term_meta( get_queried_object_id(), 'vibenews', true );
$vibenews_cat_style_template = !empty( $vibenews_cat_style['vibenews_cat_layout'] )? $vibenews_cat_style['vibenews_cat_layout'] : '';
	
?>

	<!-- Category Breadcrumb -->
    <div class="theme-breadcrumb__Wrapper theme-breacrumb-area">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12">
					<div class="breadcrumb-nav-top">
						<ul>
							<li class="breadcrumb-home-menu"><a href="<?php echo esc_url(home_url('/')); ?>"><?php esc_html_e('Home', 'vibenews'); ?></a></li>
							<li class="breadcrumb-key-menu"><?php single_cat_title(); ?></li>
						</ul>
					</div>
					<div class="theme-breacrumb-title">
						<?php echo esc_html__('Category','vibenews').' :'; ?>  <?php single_cat_title(); ?>
					</div>
					
                </div>
            </div>
        </div>
    </div>
    <!-- Category Breadcrumb End -->

	<section id="main-content" class="blog main-container cat-page-spacing" role="main">
		<div class="container">
			<div class="row">
				<div class="<?php if(is_active_sidebar('sidebar-1')) { echo "col-lg-8"; } else { echo "col-lg-12";}?> col-md-12">
				
					<?php if (have_posts() ): ?>
					
					<?php 
				
						$vibenews_cat_global = vibenews_get_option( 'vibenews_cat_layout' ); //for global	  
						
						if( is_category() && !empty( $vibenews_cat_style  ) ) {
						 
						get_template_part( 'template-parts/category-templates/'.$vibenews_cat_style_template.'' ); 
						
						} elseif ( class_exists( 'CSF' ) && !empty( $vibenews_cat_global ) ) {
							
							get_template_part( 'template-parts/category-templates/'.$vibenews_cat_global.'' );
							
						} else {
							
							get_template_part( 'template-parts/category-templates/catt-one' ); 
						}
					?>
		
					<div class="theme-pagination-style">
						<?php
							the_posts_pagination(array(
							'next_text' => '<i class="icofont-long-arrow-right"></i>',
							'prev_text' => '<i class="icofont-long-arrow-left"></i>',
							'screen_reader_text' => ' ',
							'type'               => 'list'
						));
						?>
					</div>
					
					<?php else: ?>
						<?php get_template_part('template-parts/content', 'none'); ?>
					<?php endif; ?>
					
				</div>
				
				<?php get_sidebar(); ?>
				
			</div>
		</div>
	</section>

<?php get_footer(); ?>
