(function($) {
    "use strict";
	
	
		/* ----------------------------------------------------------- */
		/*  Back to top
		/* ----------------------------------------------------------- */

		$(window).scroll(function () {
			if ($(this).scrollTop() > 300) {
				 $('.backto').fadeIn();
			} else {
				 $('.backto').fadeOut();
			}
		});
		
		
		// scroll body to 0px on click
		$('.backto').on('click', function () {
			 $('.backto').tooltip('hide');
			 $('body,html').animate({
				  scrollTop: 0
			 }, 800);
			 return false;
		});
		
		$('.backto').tooltip('hide');
		

		//Hide Loading Box (Preloader)
		function handlePreloader() {
			if($('.theme-loader-wrap').length){
				$('.theme-loader-wrap').delay(1000).fadeOut(500);
			}
		}

		if ($(".preloader-close").length) {
			$(".preloader-close").on("click", function(){
				$('.theme-loader-wrap').delay(200).fadeOut(500);
			})
		}
			
		
	
	   /* ==========================================================================
	   When document is loaded, do
	   ========================================================================== */
		
		$(window).on('load', function() {
			handlePreloader();
		});
	
	
		
		$('.lv-header-bar-1 .panel-bar-box, .lv-header-bar-2 a').on('click', function() {
			$('.overlay').addClass('visible-overlay');
			$('.vibenews-custom-panel-menu-wrapper').addClass('header-sidebar-visible');
		});
		
		$('.vibenews-custom-panel-box-effect .vibenews-custom-panel-close, .overlay').on('click', function() {
			$('.overlay').removeClass('visible-overlay');
			$('.vibenews-custom-panel-menu-wrapper').removeClass('header-sidebar-visible');
		});
	
	
		 /* ========== Popup Search Box ========== */
		 
		$(function () {
			$('#theme-serach-box_Inner').removeClass('toggled');

			$('.theme-search-custom-iconn').on('click', function (e) {
				e.stopPropagation();
				$('#theme-serach-box_Inner').toggleClass('toggled');
				$("#popup-search").focus();
			});

			$('#theme-serach-box_Inner input').on('click', function (e) {
				e.stopPropagation();
			});

			$('#theme-serach-box_Inner, body').on('click', function () {
				$('#theme-serach-box_Inner').removeClass('toggled');
			});
		});
	
	
		jQuery('.mainmenu ul.theme-main-menu').slicknav({
            allowParentLinks: true,
			prependTo: '.vibenews-responsive-menu',
			closedSymbol: "&#8594",
			openedSymbol: "&#8595",
        });
		
		jQuery('.vibenews-amp-header-wrapper .mainmenu ul.theme-main-menu').slicknav({
            allowParentLinks: true,
			prependTo: '.vibenews-responsive-menu',
			closedSymbol: "&#8594",
			openedSymbol: "&#8595",
        });
	
		
	   /* ----------------------------------------------------------- */
	   /*  Video popup
	   /* ----------------------------------------------------------- */

	  if ($('.video-play-btn').length > 0) {
	   $('.video-play-btn').magnificPopup({
		   type: 'iframe',
		   mainClass: 'mfp-with-zoom',
		   zoom: {
			   enabled: true, // By default it's false, so don't forget to enable it

			   duration: 300, // duration of the effect, in milliseconds
			   easing: 'ease-in-out', // CSS transition easing function

			   opener: function (openerElement) {
				   return openerElement.is('img') ? openerElement : openerElement.find('img');
			   }
		   }
	   });
	}


	$(document).ready(function(){    

	    /**
	    * Light & Dark Mode jQuery Toggle Using localStorage
	    */    

	    // Check for saved 'switchMode' in localStorage
	    let switchMode = localStorage.getItem('switchMode');

	    // Get selector
	    const switchModeToggle = $(' .mode-switcher ');

	    // Dark mode function
	    const enableDarkMode = function() {
	        // Add the class to the body
	        $( 'body' ).addClass('likhun-dark');
	        // Update switchMode in localStorage
	        localStorage.setItem('switchMode', 'enabled');
	    }

	    // Light mdoe function
	    const disableDarkMode = function() {
	        // Remove the class from the body
	        $( 'body' ).removeClass('likhun-dark');
	        // Update switchMode in localStorage value
	        localStorage.setItem('switchMode', null);
	    }

	    // If the user already visited and enabled switchMode
	    if (switchMode === 'enabled') {
	        enableDarkMode();
	        // Dark icon enabled
	        $( '.mode-icon-change' ).addClass( 'icofont-moon' );
	        $( '.mode-icon-change' ).removeClass( 'icofont-sun-alt' );
	    } else {
	        // Light icon enabled
	        $( '.mode-icon-change' ).addClass( 'icofont-sun-alt' );
	        $( '.mode-icon-change' ).removeClass( 'icofont-moon' );
	    }

	    // When someone clicks the button
	    switchModeToggle.on('click', function() {
	        // Change switch icon
	        $( '.mode-icon-change' ).toggleClass( 'icofont-sun-alt' );
	        $( '.mode-icon-change' ).toggleClass( 'icofont-moon' );

	        // get their switchMode setting
	        switchMode = localStorage.getItem('switchMode');

	        // if it not current enabled, enable it
	        if (switchMode !== 'enabled') {
	            enableDarkMode();              
	        // if it has been enabled, turn it off  
	        } else {  
	            disableDarkMode();              
	        }
	    });

	}); // End load document

		
					
})(jQuery);