<?php
/**
 * Header bar template part.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */

?>
<header id="top" class="vibenews-amp-header">
	
	<div class="container">
	
		<div class="vibenews-amp-header-wrapper">
			
			<div class="theme-amp-logo-left">
				<a class="custom-amp-logo" href="<?php echo esc_url(home_url('/')); ?>">
					<img class="img-fluid" src="<?php echo VIBENEWS_IMG.'/vibenews-logo.svg';?>" alt="<?php bloginfo('name'); ?>">
				</a>
			</div>
			
			<div class="theme-amp-nav-right">
				<div role="button" on="tap:sidebar.toggle" tabindex="0" class="amp-canvas-nav-box">
					<div class="header_panel_nav_wrap">
						<div class="lv-header-bar-1">
							<div class="panel-bar-box">
								<span class="lv-header-bar-line lv-header-bar-line-1"></span>
								<span class="lv-header-bar-line lv-header-bar-line-2"></span>
								<span class="lv-header-bar-line lv-header-bar-line-3"></span>
							</div>
						</div>
					</div>
				</div>						
			</div>	
			
		</div>
		
	</div>
	
</header>


<amp-sidebar class="amp-menu-slide vibenews-amp-sidebar" id="sidebar" layout="nodisplay" side="left">

    <div on="tap:sidebar.close" class="menu-close" role="button" tabindex="0">
		<span class="icon-close">&times;</span>
	</div>
	
    <div class="amp-canvas-logo">
        <a class="custom-amp-logo" href="<?php echo esc_url(home_url('/')); ?>">
			<img class="img-fluid" src="<?php echo VIBENEWS_IMG.'/vibenews-logo.webp';?>" alt="<?php bloginfo('name'); ?>">
		</a>			
    </div>
	
	<div class="header-amp-search-wrap">
		<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
			<input type="text" class="search-field" placeholder="<?php esc_attr_e( 'Search here...', 'vibenews' ); ?>" value="<?php echo get_search_query(); ?>" name="s" required>
			<button type="submit" class="search-submit">
				<?php esc_html_e( 'Go', 'vibenews' ); ?>
			</button>
		</form>
	</div>
								
	<?php
		wp_nav_menu( array(
		'theme_location' => 'primary',
		'container' => 'div',
		'container_class' => 'sidebar',
		'menu_class' => 'theme-amp-nav',
		'menu_id'        => 'theme-amp-menubar',
		'fallback_cb'  => 'vibenews_fallback_menu',
		) );
	?>
	
</amp-sidebar>


