<?php
/*
Plugin Name: Vibenews Extra
Plugin URI: https://niftythemes.com/vibenews-extra
Description: This is a helper plugin for Vibenews Theme.
Author: Nifty Themes
Version: 1.0
Author URI: https://niftythemes.com
*/

/**  Related Theme Type */

global $related_theme_type;
$related_theme_type = array('Vibenews','Vibenews Child');
//define current theme name
$current_theme = !empty( wp_get_theme() ) ? wp_get_theme()->get('Name') : '';
define('CURRENT_THEME_NAME',$current_theme);


/*
 * Define Plugin Dir Path
 * @since 1.0.0
 * */
define('VIBENEWS_EXTRA_SELF_PATH','vibenews-extra/vibenews-extra.php');
define('VIBENEWS_EXTRA_ROOT_PATH',plugin_dir_path(__FILE__));
define('VIBENEWS_EXTRA_ROOT_URL',plugin_dir_url(__FILE__));
define('VIBENEWS_EXTRA_LIB',VIBENEWS_EXTRA_ROOT_PATH.'/lib');
define('VIBENEWS_EXTRA_INC',VIBENEWS_EXTRA_ROOT_PATH .'/inc');
define('VIBENEWS_EXTRA_ADMIN',VIBENEWS_EXTRA_INC .'/admin');
define('VIBENEWS_EXTRA_ADMIN_ASSETS',VIBENEWS_EXTRA_ROOT_URL .'inc/admin/assets');
define('VIBENEWS_EXTRA_CSS',VIBENEWS_EXTRA_ROOT_URL .'assets/css');
define('VIBENEWS_EXTRA_JS',VIBENEWS_EXTRA_ROOT_URL .'assets/js');
define('VIBENEWS_EXTRA_ELEMENTOR',VIBENEWS_EXTRA_INC .'/elementor');
define('VIBENEWS_EXTRA_SHORTCODES',VIBENEWS_EXTRA_INC .'/shortcodes');
define('VIBENEWS_EXTRA_WIDGETS',VIBENEWS_EXTRA_INC .'/widgets');

/** Plugin version **/
define('VIBENEWS_CORE_VERSION','1.0.0');

//initial file
include_once ABSPATH .'wp-admin/includes/plugin.php';

if ( is_plugin_active(VIBENEWS_EXTRA_SELF_PATH) ) {

	if ( !in_array(CURRENT_THEME_NAME,$GLOBALS['related_theme_type']) && file_exists(VIBENEWS_EXTRA_INC .'/cs-framework-functions.php') ) {
		
		require_once VIBENEWS_EXTRA_INC .'/cs-framework-functions.php';
		
	}

	//plugin core file include
	
	if ( file_exists(VIBENEWS_EXTRA_INC .'/class-vibenews-extra-init.php') ) {
		require_once VIBENEWS_EXTRA_INC .'/class-vibenews-extra-init.php';
	}
	
	//Demo data import 
	
	if (file_exists(VIBENEWS_EXTRA_INC .'/demo-import.php')){
		require_once VIBENEWS_EXTRA_INC .'/demo-import.php';
	}
	
	
}



/** Add Contact Methods in the User Profile **/
function vibenews_user_contact_methods( $user_contact ) {
	
    $user_contact['facebook']   = esc_html__( 'Facebook Profile Link', 'vibenews' );
    $user_contact['twitter']    = esc_html__( 'Twitter Profile', 'vibenews' );
    $user_contact['instagram']  = esc_html__( 'Instagram', 'vibenews' ); 
	$user_contact['pinterest']  = esc_html__( 'Pinterest', 'vibenews' );
	$user_contact['youtube']    = esc_html__( 'Youtube Profile', 'vibenews' );
	
    return $user_contact; 
};
add_filter( 'user_contactmethods', 'vibenews_user_contact_methods' );

function vibenews_theme_author_box() {

    global $post;

    $theme_author_markup = '';
    // Get author's display name - NB! changed display_name to first_name. Error in code.
    $display_name = get_the_author_meta( 'display_name', $post->post_author );

    // If display name is not available then use nickname as display name
    if ( empty( $display_name ) )
    $display_name = get_the_author_meta( 'nickname', $post->post_author );

    // Get author's biographical information or description
    $user_description   = get_the_author_meta( 'user_description', $post->post_author );
    
    $user_facebook      = get_the_author_meta('facebook', $post->post_author);
    $user_twitter       = get_the_author_meta('twitter', $post->post_author);
    $user_instagram     = get_the_author_meta('instagram', $post->post_author);
	$user_pinterest     = get_the_author_meta('pinterest', $post->post_author);
	$user_youtube       = get_the_author_meta('youtube', $post->post_author);

    // Get link to the author archive page
    $user_posts = get_author_posts_url( get_the_author_meta( 'ID' , $post->post_author));
    if ( ! empty( $display_name ) )
    // Author avatar - - the number 90 is the px size of the image.
    $theme_author_markup .= '<div class="author-thumb">' . get_avatar( get_the_author_meta('ID') , 115 ) . '</div>';
    $theme_author_markup .= '<div class="theme_author_Info">';
    $theme_author_markup .= '<div class="theme_author_Title">' . esc_html__('Written By', 'vibenews'). '</div>';
    $theme_author_markup .= '<div class="theme_author__Name">' . $display_name . '</div>';
    $theme_author_markup .= '<p class="theme_author__Description">' . get_the_author_meta( 'description' ). '</p>';
    $theme_author_markup .= '<div class="theme_author_Socials">';


	// Check if author has Twitter in their profile
	
    if ( ! empty( $user_facebook ) ) {
        $theme_author_markup .= ' <a href="' . $user_facebook .'" target="_blank" rel="nofollow" title="Facebook"><i class="fa fa-facebook-f"></i> </a>';
    }
	
	    
    if ( ! empty( $user_twitter ) ) {
        $theme_author_markup .= ' <a href="' . $user_twitter .'" target="_blank" rel="nofollow" title="Twitter"><i class="fa fa-twitter"></i> </a>';
    }
	
	if ( ! empty( $user_instagram ) ) {
        $theme_author_markup .= ' <a href="' . $user_instagram .'" target="_blank" rel="nofollow" title="Instagram"><i class="fa fa-instagram"></i> </a>';
    }
	
	if ( ! empty( $user_pinterest ) ) {
        $theme_author_markup .= ' <a href="' . $user_pinterest .'" target="_blank" rel="nofollow" title="Pinterest"><i class="fa fa-pinterest"></i> </a>';
    }

    if ( ! empty( $user_youtube ) ) {
        $theme_author_markup .= ' <a href="' . $user_youtube .'" target="_blank" rel="nofollow" title="Youtube"><i class="fa fa-youtube"></i> </a>';
    }

    $theme_author_markup .= '</div></div>';

    // Pass all this info to post content 
    echo '<div class="author_bio__Wrapper" >' . $theme_author_markup . '</div>';
}

