<?php

/**
 * Elementor Widget
 * @package Vibenews
 * @since 1.0.0
 */


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class vibenews_post_grid_col extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'posts-grid-two';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Posts Grid Column', 'vibenews-extra' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-th-large'; 
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'vibenews_widgets' ];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	 
	
	protected function register_controls() {
		$this->layout_options();		
		$this->post_query_options();	
		$this->meta_options();	
		$this->design_options();
	}
	
	/**
    * Layout Options
    */
    private function layout_options() {
	
	
		$this->start_controls_section(
            'layout_option',
            [
                'label' => __( 'Layout Options', 'vibenews-extra' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'grid_post_column',
            [
                'label'     =>esc_html__( 'Select Grid Column', 'ennlil' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'col-lg-3',
                'options'   => [
                        'col-lg-6'    =>esc_html__( '2 Columns', 'ennlil' ),
                        'col-lg-4'    =>esc_html__( '3 Columns', 'ennlil' ),
                        'col-lg-3'    =>esc_html__( '4 Columns', 'ennlil' ),
                    ],
            ]
        );
			
		
		$this->add_responsive_control(
			'grid_img_height',
			[
				'label' =>esc_html__( 'Set Post Image Height', 'vibenews-extra' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 294,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 294,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 294,
					'unit' => 'px',
				],
				
				'default'  => [
					'unit' => 'px',
					'size' => 294,
				],
				
				'selectors' => [
					'{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .news-post-grid-thumbnail-wrap img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);		
		
		$this->add_control(
            'display_top_title',
            [
                'label' => esc_html__('Display Top Heading', 'vibenews-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vibenews-extra'),
                'label_off' => esc_html__('No', 'vibenews-extra'),
                'default' => 'yes',
            ]
        );
		
		$this->add_control(
			'post_gridsone_block_title',
			[
				'label' => __( 'Section Title', 'vibenews-extra' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'Recommended for you', 'vibenews-extra' ),
				'placeholder' => __( 'Type Your title here', 'vibenews-extra' ),
			]
		);
		
		
		$this->end_controls_section();
	
	}
	
	/**
    * Post Query Options
    */
    private function post_query_options() {
	
	
		$this->start_controls_section(
            'post_query_option',
            [
                'label' => __( 'Post Options', 'vibenews-extra' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		
		// Post Sort
		
        $this->add_control(
            'post_sorting',
            [
                'type'    => \Elementor\Controls_Manager::SELECT2,
                'label' => esc_html__('Post Sorting', 'vibenews-extra'),
                'default' => 'date',
                'options' => [
					'date' => esc_html__('Recent Post', 'vibenews-extra'),
                    'rand' => esc_html__('Random Post', 'vibenews-extra'),
					'title'         => __( 'Title Sorting Post', 'vibenews-extra' ),
                    'modified' => esc_html__('Last Modified Post', 'vibenews-extra'),
                    'comment_count' => esc_html__('Most Commented Post', 'vibenews-extra'),
					
                ],
            ]
        );		
		
		// Post Order
		
        $this->add_control(
            'post_ordering',
            [
                'type'    => \Elementor\Controls_Manager::SELECT2,
                'label' => esc_html__('Post Ordering', 'vibenews-extra'),
                'default' => 'DESC',
                'options' => [
					'DESC' => esc_html__('Desecending', 'vibenews-extra'),
                    'ASC' => esc_html__('Ascending', 'vibenews-extra'),
                ],
            ]
        );
		
		
		// Post Categories
		
		$this->add_control(
			'post_cat',
			[
				'label' => __( 'Select Categories', 'vibenews-extra' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => $this->select_param_cate_post(),
				'multiple' => true,
				'label_block' => true,
				'placeholder' => __( 'All Categories', 'vibenews-extra' ),
			]
		);
	
		$this->add_control(
			'post_tags',
			[
				'label'       => esc_html__('Select Tags', 'vibenews-extra'),
				'type'      => \Elementor\Controls_Manager::SELECT2,
				'options'     => vibenews_post_tags(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
		
		
		// Post Items.
		
        $this->add_control(
            'post_number',
			[
				'label'         => esc_html__( 'Number Of Posts', 'vibenews-extra' ),
				'type'          => \Elementor\Controls_Manager::NUMBER,
				'default'       => '1',
			]
        );
		
		// Specific Posts by ID.
        $this->add_control(
            'post_ids',
            [
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label'       => __( 'Show specific posts by ID', 'deo-elementor' ),
                'placeholder' => __( 'ex.: 256, 54, 78', 'deo-elementor' ),
                'description'   => __( 'Paste post ID\'s separated by commas. To find ID, click edit post and you\'ll find it in the browser address bar', 'deo-elementor' ),
                'default'     => '',
                'separator'     => 'before',
                'label_block' => true,
            ]
        );
		
		$this->add_control(
            'enable_offset_post',
            [
               'label' => esc_html__('Enable Skip Post', 'vibenews-extra'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Yes', 'vibenews-extra'),
               'label_off' => esc_html__('No', 'vibenews-extra'),
               'default' => 'no',
               
            ]
        );
      
        $this->add_control(
			'post_offset_count',
			  [
			   'label'         => esc_html__( 'Skip Post Count', 'vibenews-extra' ),
			   'type'          => \Elementor\Controls_Manager::NUMBER,
			   'default'       => '1',
			   'condition' => [ 'enable_offset_post' => 'yes' ]

			  ]
        );
		
		
		$this->end_controls_section();
	
	}	
	
	/**
    * Meta Options
    */
    private function meta_options() {
	
	
		$this->start_controls_section(
            'meta_option',
            [
                'label' => __( 'Meta Options', 'vibenews-extra' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'display_excerpt',
            [
                'label' => esc_html__('Display Post Excerpt', 'ennlil-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ennlil-extra'),
                'label_off' => esc_html__('No', 'ennlil-extra'),
                'default' => 'yes',
            ]
        );

		$this->add_control(
         	'display_author',
         	[
				 'label' => esc_html__('Display Author', 'vibenews-extra'),
				 'type' => \Elementor\Controls_Manager::SWITCHER,
				 'label_on' => esc_html__('Yes', 'vibenews-extra'),
				 'label_off' => esc_html__('No', 'vibenews-extra'),
				 'default' => 'yes',
         	]
     	);

     	$this->add_control(
            'display_cat',
            [
                'label' => esc_html__('Display Category Name', 'vibenews-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vibenews-extra'),
                'label_off' => esc_html__('No', 'vibenews-extra'),
                'default' => 'yes',
            ]
        );
		
		$this->add_control(
            'display_date',
            [
                'label' => esc_html__('Display Date', 'vibenews-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vibenews-extra'),
                'label_off' => esc_html__('No', 'vibenews-extra'),
                'default' => 'yes',
            ]
        );
		
		
		$this->add_control(
            'show_pagination',
            [
                'label' => __('Show Pagination', 'vibenews-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'vibenews-extra'),
                'label_off' => __('Hidden', 'vibenews-extra'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

	
		$this->end_controls_section();
	
	}	
	
	/**
    * Design Options
    */
    private function design_options() {
	
	
		$this->start_controls_section(
            'design_option',
            [
                'label' => __( 'Typography', 'vibenews-extra' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'gridd_block_top_title_typography',
              'label' => esc_html__( 'Top Title Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-post-grid-design-one .post-block-title-wrapper h2.post-block-title',
           ]
        );	
		
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'block_dgone_title_typography',
              'label' => esc_html__( 'Post Title Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .grid-content-top h3.post-title',
           ]
        );		
		
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'block_dgone_excerpt_typography',
              'label' => esc_html__( 'Post Excerpt Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .grid-content-top .post-excerpt-box p',
           ]
        );	
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'dgone_cat_meta_typography',
              'label' => esc_html__( 'Category Meta Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .post-cat-box.post-block-meta-cat a.news-cat_Name',
           ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
			   'name' => 'dgone_date_box_typography',
			   'label' => esc_html__( 'Date Meta Typography', 'vibenews-extra' ),
			   'selector' => '{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .post-date-box.post-block-meta-date',
			]
		 );
		
		$this->add_control('gridd_block_top_title_color', [
            'label' => esc_html__('Top Title Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-post-grid-design-one .post-block-title-wrapper h2.post-block-title" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('block_dgone_title_color', [
            'label' => esc_html__('Post Title Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .grid-content-top h3.post-title a" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('block_dgone_excerpt_color', [
            'label' => esc_html__('Post Excerpt Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .grid-content-top .post-excerpt-box p" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('block_dgone_cat_color', [
            'label' => esc_html__('Post Category Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .post-cat-box.post-block-meta-cat a.news-cat_Name" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('block_dgone_date_color', [
            'label' => esc_html__('Post Date Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-post-grid-design-one .grid-style-one-inner .post-date-box.post-block-meta-date" => "color: {{VALUE}}"
            ]
        ]);
		


		
		$this->add_control(
          'title_length',
          [
            'label'         => esc_html__( 'Post Title Length', 'vibenews-extra' ),
            'type'          => \Elementor\Controls_Manager::NUMBER,
            'default'       => '6',
          ]
        );

        $this->add_control(
          'content_length',
          [
            'label'         => esc_html__( 'Post Excerpt Length', 'ennlil-extra' ),
            'type'          => \Elementor\Controls_Manager::NUMBER,
            'default'       => '15',
          ]
        );
		

		
		$this->end_controls_section();
	
	}	
		


	protected function render() {
		
		
		$settings = $this->get_settings_for_display();
		
		$number_show = ( !empty( $settings['post_number'] ) ? $settings['post_number'] : 6 );
		
		$grid_post_column = $settings['grid_post_column'];
		
		$display_top_title = $settings['display_top_title'];
		
		$title_limit = $settings['title_length'];
		$content_limit = $settings['content_length'];
		$post_count = $settings['post_number'];
		$post_order  = $settings['post_ordering'];
		$post_sortby = $settings['post_sorting']; 
		
		$display_blog_excerpt = $settings['display_excerpt'];
		$display_blog_cat = $settings['display_cat'];
		$display_blog_author = $settings['display_author'];
		$display_blog_date = $settings['display_date'];
		
		$string_ID = $settings['post_ids'];
        $post_ID = ( ! empty( $string_ID ) ) ? array_map( 'intval', explode( ',', $string_ID ) ) : '';
		

		//$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
		
		
		if ( get_query_var('paged') ) {
		    $paged = get_query_var('paged');
		} elseif ( get_query_var('page') ) { // 'page' is used instead of 'paged' on Static Front Page
		    $paged = get_query_var('page');
		} else {
		    $paged = 1;
		}
				
		if( $settings['post_cat'] ){
            $args = array(
            	'paged' => $paged,
	            'post_type' => 'post',
	            'post_status' => 'publish',
	            'posts_per_page' => $number_show,
				'order' => $post_order,
				'orderby' => $post_sortby,
	            'tax_query' => array(
			        array(
			            'taxonomy' => 'category',
			            'field'    => 'slug',
			            'terms'    => $settings['post_cat']
			        ),
			    ),
	        );
        }else{
            $args = array(
            	'paged' => $paged,
                'post_type' => 'post',
	            'post_status' => 'publish',
	            'posts_per_page' => $number_show,
				'tag__in'        => $settings['post_tags'],
				'ignore_sticky_posts' => 1,
				'suppress_filters' => false,
            );
        }
		
		// Post Offset		
		if($settings['enable_offset_post'] == 'yes') {
			$args['offset'] = $settings['post_offset_count'];
		}

		//Specific Posts by ID's
        if ( ! empty( $settings['post_ids'] ) ) {
            $args['post__in'] = $post_ID;
        }
		
		// Query
        //$query = new \WP_Query( $args ); 
		$the_query = new \WP_Query($args);
		
		if($the_query->have_posts()) :
		
		?>


		
		<div class="theme-news-post-block-wrapper theme-post-grid-style theme-post-grid-design-one">
		
			<div class="row">
				<div class="col-lg-12">
				
				<?php if($display_top_title=='yes'): ?>	
				<div class="post-block-title-wrapper">
					<h2 class="post-block-title"><span><?php echo wp_kses_post( $settings['post_gridsone_block_title']  ); ?></span></h2>
				</div>
				<?php endif; ?>
				
				</div>
			</div>
		
		
			<div class="row">
			
			<?php while ($the_query->have_posts()) : $the_query->the_post(); ?>
			
			<div class="<?php echo esc_attr($grid_post_column);?>">
			
				<div class="post-block-item-one post-block-item-two grid-style-one-inner">
					
					<div class="news-post-grid-thumbnail">
						<a href="<?php the_permalink(); ?>" class="news-post-grid-thumbnail-wrap">
							<img src="<?php echo esc_attr(esc_url(get_the_post_thumbnail_url(null, 'full'))); ?>" alt="<?php the_title_attribute(); ?>">
						</a>
					</div>
					
					<div class="news-post-grid-content grid-content-top grid-content-inner">
					
						<div class="blog-post-meta-items post-block-meta-top">
							<?php if($display_blog_cat=='yes'): ?>	
							<div class="post-cat-box post-block-meta-cat">
							<?php require VIBENEWS_THEME_DIR . '/template-parts/cat-color.php'; ?>
							</div>
							<?php endif; ?>
							
							<?php if($display_blog_date=='yes'): ?>
							<div class="post-date-box post-block-meta-date">
							<?php echo esc_html( get_the_date( 'F j, Y' ) ); ?>
							</div>
							<?php endif; ?>	
						</div>
						
						<h3 class="post-title">
							<a href="<?php the_permalink(); ?>"><?php echo esc_html( wp_trim_words(get_the_title(), $title_limit,'') ); ?></a>
						</h3>
					
						<?php if($display_blog_excerpt =='yes'): ?> 
						<div class="post-excerpt-box">
							<p><?php echo esc_html( wp_trim_words(get_the_excerpt(), $content_limit ,'') );?></p>
						</div>
						<?php endif; ?>	
						
					</div>
					
				</div>

			</div>
				
			<?php endwhile; wp_reset_postdata();?>
				
			
			
		
			</div>
		</div>
		
		<div class="custom-pagination-grid">
		
		<?php 
			if ( 'yes' === $settings['show_pagination'] ) {
			    if ( get_query_var('paged') ) {
				    $paged = get_query_var('paged');
				} elseif ( get_query_var('page') ) { // 'page' is used instead of 'paged' on Static Front Page
				    $paged = get_query_var('page');
				} else {
				    $paged = 1;
				}
				$pagination = array(
					'base'          => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
					'format' => '?paged=%#%',
					'current' => max( 1, $paged ),
					'total' => $the_query->max_num_pages,                      
					'prev_text' => 'Prev',
					'next_text' => 'Next',       
					'type'          => 'list',
					'end_size'      => 3,
					'mid_size'      => 3
				);
				$return =  paginate_links( $pagination );
				echo str_replace( "<ul class='page-numbers'>", '<ul class="page-pagination">', $return );
			}		
	    ?>
		
		</div>
		
	    <?php endif; ?>
		
		

		<?php 
      }
		
   
	
	public function select_param_cate_post() {
		$args = array( 'orderby=name&order=ASC&hide_empty=0' );
		$terms = get_terms( 'category', $args );
		$cat = array();
		if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){		    
		    foreach ( $terms as $term ) {
		        $cat[$term->slug] = $term->name;
		    }
		}
	  	return $cat;
	}

	
	
}

