<?php

/**
 * Elementor Widget
 * @package Vibenews
 * @since 1.0.0
 */


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class vibenews_post_tab_one extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'posts-tab-one';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Vibenews Posts Tab Style 1', 'vibenews-extra' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-picture-o';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'vibenews_widgets' ];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	 
	
	protected function register_controls() {
		$this->tab_options();		
		$this->post_query_options();	
		$this->meta_options();	
		$this->design_options();
	}
	
	/**
    * Tab Item Options
    */
    private function tab_options() {
	
	
		$this->start_controls_section(
            'tab_option',
            [
                'label' => __( 'Tab Item and Content', 'vibenews-extra' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
         'tabs',
         [
             'label' => esc_html__('Tab Items', 'vibenews-extra'),
             'type' => \Elementor\Controls_Manager::REPEATER,
             'default' => [
                 [
                     'tab_title' => esc_html__('Add Tab Item Menu', 'vibenews-extra'),
                 ],
             ],
			 
             'fields' => [
			 
                [   'name' => 'post_categories',
                     'label' =>esc_html__('Select Categories', 'vibenews-extra'),
                     'type'      => \Elementor\Controls_Manager::SELECT2,
                     'options'   => $this->posts_cat_list(),
                     'label_block' => true,
                     'multiple'  => true,
					 'placeholder' => __( 'All Categories', 'vibenews-extra' ),
                ],
				
				[   'name' => 'post_tags',
                     'label' =>esc_html__('Select Tags', 'vibenews-extra'),
                     'type'      => \Elementor\Controls_Manager::SELECT2,
                     'options'   => vibenews_post_tags(),
                     'label_block' => true,
                     'multiple'  => true,
					 'placeholder' => __( 'All Tags', 'vibenews-extra' ),
                ],
				
				
				
				
                [   'name' => 'tab_menu_name',
                     'label'         => esc_html__( 'Tab Menu Name', 'vibenews-extra' ),
                     'type'          => \Elementor\Controls_Manager::TEXT,
                     'default'       => 'Add Tab Menu',
                ],
			   
                [   
                  'name' => 'enable_offset_post',
                  'label'         => esc_html__( 'Enable Skip Post', 'vibenews-extra' ),
                  'type' => \Elementor\Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vibenews-extra'),
                  'label_off' => esc_html__('No', 'vibenews-extra'),
				  'default' => 'no',
                ],
			   
                [  
                   'name' => 'post_offset_count',
                   'label'         => esc_html__( 'Skip Post Count', 'vibenews-extra' ),
                   'type'          => \Elementor\Controls_Manager::NUMBER,
                   'default'       => '1',
                   'condition' => [ 'enable_offset_post' => 'yes' ]
                ],
			   
             ],
         ]
     );
				
		
		$this->end_controls_section();
	
	}
	
	/**
    * Post Query Options
    */
    private function post_query_options() {
	
	
		$this->start_controls_section(
            'post_query_option',
            [
                'label' => __( 'Post Options', 'vibenews-extra' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		// Post Items
		
        $this->add_control(
            'post_number',
			[
				'label'         => esc_html__( 'Number Of Posts', 'vibenews-extra' ),
				'type'          => \Elementor\Controls_Manager::NUMBER,
				'default'       => '1',
			]
        );
		
		
		// Post Sort
		
        $this->add_control(
            'post_sorting',
            [
                'type'    => \Elementor\Controls_Manager::SELECT2,
                'label' => esc_html__('Post Sorting', 'vibenews-extra'),
                'default' => 'date',
                'options' => [
					'date' => esc_html__('Recent Post', 'vibenews-extra'),
                    'rand' => esc_html__('Random Post', 'vibenews-extra'),
					'title'         => __( 'Title Sorting Post', 'vibenews-extra' ),
                    'modified' => esc_html__('Last Modified Post', 'vibenews-extra'),
                    'comment_count' => esc_html__('Most Commented Post', 'vibenews-extra'),
					
                ],
            ]
        );		
		
		// Post Order
		
        $this->add_control(
            'post_ordering',
            [
                'type'    => \Elementor\Controls_Manager::SELECT2,
                'label' => esc_html__('Post Ordering', 'vibenews-extra'),
                'default' => 'DESC',
                'options' => [
					'DESC' => esc_html__('Desecending', 'vibenews-extra'),
                    'ASC' => esc_html__('Ascending', 'vibenews-extra'),
                ],
            ]
        );
	

		$this->end_controls_section();
	
	}	
	
	/**
    * Meta Options
    */
    private function meta_options() {
	
	
		$this->start_controls_section(
            'meta_option',
            [
                'label' => __( 'Meta Options', 'vibenews-extra' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'display_cat',
            [
                'label' => esc_html__('Display Category Name', 'vibenews-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vibenews-extra'),
                'label_off' => esc_html__('No', 'vibenews-extra'),
                'default' => 'yes',
            ]
        );
		
		$this->add_control(
            'display_excerpt',
            [
                'label' => esc_html__('Display Post Excerpt', 'evior-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'evior-extra'),
                'label_off' => esc_html__('No', 'evior-extra'),
                'default' => 'yes',
            ]
        );
		
		$this->add_control(
            'display_excerpt_small',
            [
                'label' => esc_html__('Display Small Post Excerpt', 'evior-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'evior-extra'),
                'label_off' => esc_html__('No', 'evior-extra'),
                'default' => 'yes',
            ]
        );

		$this->add_control(
         	'display_author',
         	[
				 'label' => esc_html__('Display Author', 'vibenews-extra'),
				 'type' => \Elementor\Controls_Manager::SWITCHER,
				 'label_on' => esc_html__('Yes', 'vibenews-extra'),
				 'label_off' => esc_html__('No', 'vibenews-extra'),
				 'default' => 'yes',
         	]
     	);
		
		$this->add_control(
            'display_date',
            [
                'label' => esc_html__('Display Date', 'vibenews-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vibenews-extra'),
                'label_off' => esc_html__('No', 'vibenews-extra'),
                'default' => 'yes',
            ]
        );
		
		$this->add_control(
            'display_read_time',
            [
                'label' => esc_html__('Display Post Read Time', 'vibenews-extra'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vibenews-extra'),
                'label_off' => esc_html__('No', 'vibenews-extra'),
                'default' => 'no',
            ]
        );

	
		$this->end_controls_section();
	
	}	
	
	/**
    * Design Options
    */
    private function design_options() {
	
	
		$this->start_controls_section(
            'design_option',
            [
                'label' => __( 'Design & Typography Options', 'vibenews-extra' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		


		$this->add_responsive_control(
			'tabone_big_post_img_height',
			[
				'label' =>esc_html__( 'Set Top Big Post Image height', 'vibenews-extra' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 400,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 400,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 300,
					'unit' => 'px',
				],
				
				'default'  => [
					'unit' => 'px',
					'size' => 400,
				],
				
				'selectors' => [
					'{{WRAPPER}} .theme_post_Tab__content .theme-news-post-block.post-block-item.post-block-item-one .news-post-grid-thumbnail a img' => 'height: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);	


		$this->add_responsive_control(
			'tabone_list_post_img_width',
			[
				'label' =>esc_html__( 'Set Top List Post Image Width', 'vibenews-extra' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 165,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 165,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 165,
					'unit' => 'px',
				],
				
				'default'  => [
					'unit' => 'px',
					'size' => 165,
				],
				
				'selectors' => [
					'{{WRAPPER}} .theme_post_Tab__content .post-gridstyle-two.tab-bottom-grid-style .post-grid-wrapper-two-inner .grid-thumbnail-two-wrap' => 'min-width: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);	

		$this->add_responsive_control(
			'tabone_list_post_img_height',
			[
				'label' =>esc_html__( 'Set Top List Post Image Height', 'vibenews-extra' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 110,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 110,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 110,
					'unit' => 'px',
				],
				
				'default'  => [
					'unit' => 'px',
					'size' => 110,
				],
				
				'selectors' => [
					'{{WRAPPER}} .theme-tab-one-wrapper .tab-post-small-list-wrap .small-post-list-item-block .news-post-grid-thumbnail a img' => 'height: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);	

		$this->add_control(
			'tab_title_text',
				[
					'label' => esc_html__('Section Title', 'vibenews-extra'),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Featured News', 'vibenews-extra' ),
				]
		);

		
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'tabitemone_top_title_typography',
              'label' => esc_html__( 'Top Title Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .tab-section-title h2.tab-item-title',
           ]
        );	
		
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'tabitemone_large_title_typography',
              'label' => esc_html__( 'Large Post Title Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .post-block-item-one .grid-content-top h3.post-title',
           ]
        );		
		
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'tabitemone_large_excerpt_typography',
              'label' => esc_html__( 'Large Post Excerpt Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .post-block-item-one .grid-content-top .post-excerpt-box p',
           ]
        );	
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'tabitemone_large_cat_meta_typography',
              'label' => esc_html__( 'Large Category Meta Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .tab-one-block-top .grid-content-top .post-cat-box.post-block-meta-cat a.news-cat_Name',
           ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
			   'name' => 'tabitemone_large_date_box_typography',
			   'label' => esc_html__( 'Large Date Meta Typography', 'vibenews-extra' ),
			   'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .tab-one-block-top .post-date-box.post-block-meta-date',
			]
		 );
		 
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'tabitemone_small_title_typography',
              'label' => esc_html__( 'Small Post Title Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .grid-content-top.small-post-list-inner h3.post-title',
           ]
        );		
		
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'tabitemone_small_excerpt_typography',
              'label' => esc_html__( 'Small Post Excerpt Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .grid-content-top.small-post-list-inner .post-excerpt-box p',
           ]
        );	
		
		$this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
              'name' => 'tabitemone_small_cat_meta_typography',
              'label' => esc_html__( 'Small Category Meta Typography', 'vibenews-extra' ),
              'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .tab-post-small-list-wrap .small-post-list-inner .post-cat-box.post-block-meta-cat a.news-cat_Name',
           ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
			   'name' => 'tabitemone_small_date_box_typography',
			   'label' => esc_html__( 'Small Date Meta Typography', 'vibenews-extra' ),
			   'selector' => '{{WRAPPER}} .theme-tab-one-wrapper .tab-post-small-list-wrap .small-post-list-inner .post-date-box.post-block-meta-date',
			]
		 );
		 
		
		$this->add_control('tabone_top_title_color', [
            'label' => esc_html__('Top Title Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper h2.tab-item-title" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('tabone_large_title_color', [
            'label' => esc_html__('Large Post Title Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper .post-block-item-one .grid-content-top h3.post-title a" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('tabone_large_excerpt_color', [
            'label' => esc_html__('Large Post Excerpt Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper .post-block-item-one .grid-content-top .post-excerpt-box p" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('tabone_large_cat_color', [
            'label' => esc_html__('Large Post Category Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper .tab-one-block-top .grid-content-top .post-cat-box.post-block-meta-cat a.news-cat_Name" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('tabone_large_date_color', [
            'label' => esc_html__('Large Post Date Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper .tab-one-block-top .post-date-box.post-block-meta-date" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('tabone_small_title_color', [
            'label' => esc_html__('Small Post Title Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper .grid-content-top.small-post-list-inner h3.post-title a" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('tabone_small_excerpt_color', [
            'label' => esc_html__('Small Post Excerpt Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper .grid-content-top.small-post-list-inner .post-excerpt-box p" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('tabone_small_cat_color', [
            'label' => esc_html__('Small Post Category Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper .tab-post-small-list-wrap .small-post-list-inner .post-cat-box.post-block-meta-cat a.news-cat_Name" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('tabone_small_date_color', [
            'label' => esc_html__('Small Post Date Color', 'vibenews-extra'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-tab-one-wrapper .tab-post-small-list-wrap .small-post-list-inner .post-date-box.post-block-meta-date" => "color: {{VALUE}}"
            ]
        ]);



		$this->add_control(
          'title_length',
          [
            'label'         => esc_html__( 'Big Block Post Title Length', 'vibenews-extra' ),
            'type'          => \Elementor\Controls_Manager::NUMBER,
            'default'       => '10',
          ]
        );
		
		$this->add_control(
          'content_length',
          [
            'label'         => esc_html__( 'Large Post Excerpt Length', 'evior-extra' ),
            'type'          => \Elementor\Controls_Manager::NUMBER,
            'default'       => '15',
          ]
        );
		
		$this->add_control(
          'content_limit_small',
          [
            'label'         => esc_html__( 'Small Post Excerpt Length', 'evior-extra' ),
            'type'          => \Elementor\Controls_Manager::NUMBER,
            'default'       => '15',
          ]
        );
		
		

		

		$this->end_controls_section();
	
	}	
		


	protected function render() {
		
		
		$settings = $this->get_settings_for_display();
		
		$tab_title_text   = $settings['tab_title_text'];
		
		$title_limit = $settings['title_length'];

		$content_limit = $settings['content_length'];
		$content_limit_small = $settings['content_limit_small'];
		
		$post_number        = $settings['post_number'];
		$post_order         = $settings['post_ordering'];
        $post_sortby        = $settings['post_sorting'];
		
		$display_blog_excerpt = $settings['display_excerpt']; 
		$display_blog_excerpt_small = $settings['display_excerpt_small']; 

		$display_blog_cat = $settings['display_cat'];
		$display_blog_author = $settings['display_author'];
		$display_blog_date = $settings['display_date'];

		$display_read_time = $settings['display_read_time'];
		
		$tabs               = $settings['tabs'];
        $post_count         = count($tabs);

	?>




	    <div class="theme_post_Tab__wrapper news_tab__Wrapper theme-tab-one-wrapper">
            <div class="post-block-element news_tab_Block">
				
					<div class="tab-section-title">
						<h2 class="tab-item-title">
						<span><?php echo esc_html($tab_title_text); ?></span>
						</h2>
					</div>
					
                    <ul class="nav nav-tabs" role="tablist">
                        <?php
                              foreach ( $tabs as $tab_Menu_key=>$value ) {
                                       
                                    if( $tab_Menu_key == 0 ){
                                          echo '<li class="nav-item"><a class="nav-link active" href="#'.$this->get_id().$value['_id'].'" data-toggle="tab"><span class="tab_menu_Item">'.$value['tab_menu_name'].'</span></a></li>';
                                    } else {
                                          echo '<li class="nav-item"><a class="nav-link" href="#'.$this->get_id().$value['_id'].'" data-toggle="tab"><span class="tab_menu_Item">'.$value['tab_menu_name'].'</span></a></li>';
                                    }
                                 
                              }
                        ?>
                    </ul>

                    <div class="theme_post_Tab__content tab-content">

                     <?php
                     
                     foreach ($tabs as $tab_Content_key=>$value) {
                      
                        if( $tab_Content_key == 0){
                           echo '<div role="tabpanel" class="tab-pane fade active show" id="'.$this->get_id().$value['_id'].'">';
                        } else {
                           echo '<div role="tabpanel" class="tab-pane fade" id="'.$this->get_id().$value['_id'].'">';
                        }
                        
                        $args = array(
                           'post_type'   =>  'post',
                           'post_status' => 'publish',
                           'posts_per_page' => $post_number,
                           'order' => $post_order,
                           'orderby' => $post_sortby, 
                           'ignore_sticky_posts' => 1,
                        );
						
						
						// Category
						
						if ( ! empty( $value['post_categories'] ) ) {
							$args['category_name'] = implode(',', $value['post_categories']);
						}
						
						// Tag
						
						if ( ! empty( $value['post_tags'] ) ) {
							$args['tag__in'] = $value['post_tags'];
						}
		
						// Post Offset
						
						if($value['enable_offset_post'] == 'yes') {
							$args['offset'] = $value['post_offset_count'];
						}
						

                   
                       $Tabquery = new \WP_Query( $args );
                     
                     ?>

                     <?php if ( $Tabquery->have_posts() ) : ?>
					 
                        <div class="theme_post_Tab__block block-tab-item">
                            <div class="row">
							  
								<?php while ($Tabquery->have_posts()) : $Tabquery->the_post();?>
								
                                <?php if ( $Tabquery->current_post == 0 ): ?>
								
								<div class="col-lg-6 col-sm-12">
									
									<div class="theme-news-post-block post-block-item post-block-item-one post-block-item-two tab-one-block-top">
										<div class="news-post-grid-thumbnail">
											<a href="<?php the_permalink(); ?>" class="news-post-grid-thumbnail-wrap">
												<img src="<?php echo esc_attr(esc_url(get_the_post_thumbnail_url(null, 'full'))); ?>" alt="<?php the_title_attribute(); ?>">
											</a>
										</div>
										<div class="news-post-grid-content grid-content-top grid-content-inner">
										
											<div class="blog-post-meta-items post-block-meta-top">
												<?php if($display_blog_cat=='yes'): ?>	
												<div class="post-cat-box post-block-meta-cat">
												<?php require VIBENEWS_THEME_DIR . '/template-parts/cat-color.php'; ?>
												</div>
												<?php endif; ?>
												
												<?php if($display_blog_date=='yes'): ?>
												<div class="post-date-box post-block-meta-date">
												<?php echo esc_html( get_the_date( 'F j, Y' ) ); ?>
												</div>
												<?php endif; ?>	
											</div>
											<h3 class="post-title">
												<a href="<?php the_permalink(); ?>"><?php echo esc_html( wp_trim_words(get_the_title(), $title_limit,'') ); ?></a>
											</h3>
										
											<?php if($display_blog_excerpt =='yes'): ?> 
											<div class="post-excerpt-box">
												<p><?php echo esc_html( wp_trim_words(get_the_excerpt(), $content_limit ,'') );?></p>
											</div>
											<?php endif; ?>	
										</div>
									</div>

								</div>

								<?php elseif ( $Tabquery->current_post == 1 ): ?>

								<div class="col-lg-6 col-sm-12">
									
									<div class="theme-news-post-block post-block-item post-block-item-one post-block-item-two tab-one-block-top">
										<div class="news-post-grid-thumbnail">
											<a href="<?php the_permalink(); ?>" class="news-post-grid-thumbnail-wrap">
												<img src="<?php echo esc_attr(esc_url(get_the_post_thumbnail_url(null, 'full'))); ?>" alt="<?php the_title_attribute(); ?>">
											</a>
										</div>
										<div class="news-post-grid-content grid-content-top grid-content-inner">
										
											<div class="blog-post-meta-items post-block-meta-top">
												<?php if($display_blog_cat=='yes'): ?>	
												<div class="post-cat-box post-block-meta-cat">
												<?php require VIBENEWS_THEME_DIR . '/template-parts/cat-color.php'; ?>
												</div>
												<?php endif; ?>
												
												<?php if($display_blog_date=='yes'): ?>
												<div class="post-date-box post-block-meta-date">
												<?php echo esc_html( get_the_date( 'F j, Y' ) ); ?>
												</div>
												<?php endif; ?>	
											</div>
											<h3 class="post-title">
												<a href="<?php the_permalink(); ?>"><?php echo esc_html( wp_trim_words(get_the_title(), $title_limit,'') ); ?></a>
											</h3>
										
											<?php if($display_blog_excerpt =='yes'): ?> 
											<div class="post-excerpt-box">
												<p><?php echo esc_html( wp_trim_words(get_the_excerpt(), $content_limit ,'') );?></p>
											</div>
											<?php endif; ?>	
										</div>
									</div>

								</div>
								
                                <?php else: ?>
                                <?php if ( $Tabquery->current_post == 2 ): ?>
								
								<?php endif; ?>  

                                <div class="col-lg-6 col-sm-12 custom-tab-small-col">

									<article <?php post_class( 'tab-post-small-list-wrap' ); ?>>
										<div class="small-post-list-item-block">
											<div class="news-post-grid-thumbnail">
												<a href="<?php the_permalink(); ?>" class="news-post-grid-thumbnail-wrap">
													<img src="<?php echo esc_attr(esc_url(get_the_post_thumbnail_url(null, 'full'))); ?>" alt="<?php the_title_attribute(); ?>">
												</a>
											</div>
											<div class="news-post-grid-content grid-content-top small-post-list-inner">
											
												<div class="blog-post-meta-items post-block-meta-top">
													<?php if($display_blog_cat=='yes'): ?>	
													<div class="post-cat-box post-block-meta-cat">
													<?php require VIBENEWS_THEME_DIR . '/template-parts/cat-color.php'; ?>
													</div>
													<?php endif; ?>
													
													<?php if($display_blog_date=='yes'): ?>
													<div class="post-date-box post-block-meta-date">
													<?php echo esc_html( get_the_date( 'F j, Y' ) ); ?>
													</div>
													<?php endif; ?>	
												</div>
												
												<h3 class="post-title">
													<a href="<?php the_permalink(); ?>"><?php echo esc_html( wp_trim_words(get_the_title(), $title_limit,'') ); ?></a>
												</h3>
												
												<?php if($display_blog_excerpt_small =='yes'): ?> 
												<div class="post-excerpt-box">
													<p><?php echo esc_html( wp_trim_words(get_the_excerpt(), $content_limit_small ,'') );?></p>
												</div>
												<?php endif; ?>
											
											
											</div>
										</div>
									</article>
									
								</div>

                                <?php if (($Tabquery->current_post + 2) == ($Tabquery->post_count)) { ?>


                                <?php } ?> 
                                <?php endif ?>

                                <?php 
                                endwhile; ?>
								
                              </div>
                           </div>
                        <?php wp_reset_postdata(); ?>
                     <?php endif; ?>
					 
                     </div>
                     <?php } ?>
                </div>
          </div>
      </div>


		
	
	<?php 
	
    }
		
   
   	public function posts_cat_list() {
		
		$terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => true
		) );

      $cat_list = [];
      foreach($terms as $post) {
      	$cat_list[$post->slug]  = [$post->name];
      }
      return $cat_list;
	
	}	
	

}

